

class PATH_RELATIONS(object):  # noqa
    NO_INTERSECTION = "No Intersection"
    SUB_PATH = "Sub Path"
    SUPER_PATH = "Super Path"
    SUB_PATH_PARTIALY = "Sub Path Partialy"
    SUPER_PATH_PARTIALY = "Super Path Partialy"
    INTERSECTION = "Intersection"

    EQUAL = "Equal"

    REVERSED_SUB_PATH = "Reversed Sub Path"
    REVERSED_SUPER_PATH = "Reversed Super Path"
    REVERSED_SUB_PATH_PARTIALY = "Reversed Sub Path Partialy"
    REVERSED_SUPER_PATH_PARTIALY = "Reversed Super Path Partialy"
    REVERSED_INTERSECTION = "Reversed Intersection"

    UNKNOWN = "Unknown"

    _invert = (
        (SUB_PATH, SUPER_PATH),
        (SUB_PATH_PARTIALY, SUPER_PATH_PARTIALY),
        (REVERSED_SUB_PATH, REVERSED_SUPER_PATH),
        (REVERSED_SUB_PATH_PARTIALY, REVERSED_SUPER_PATH_PARTIALY),
    )

    _reverse = (
        (SUB_PATH, REVERSED_SUB_PATH),
        (SUPER_PATH, REVERSED_SUPER_PATH),
        (SUB_PATH_PARTIALY, REVERSED_SUB_PATH_PARTIALY),
        (SUPER_PATH_PARTIALY, REVERSED_SUPER_PATH_PARTIALY),
    )

    @classmethod
    def invert(cls, relation):
        for r1, r2 in cls._invert:
            if r1 == relation:
                return r2
            elif r2 == relation:
                return r1

    @classmethod
    def reverse(cls, relation):
        for r1, r2 in cls._reverse:
            if r1 == relation:
                return r2
            elif r2 == relation:
                return r1


class RelationResult(PATH_RELATIONS):
    start_index = None
    end_index = None
    code = PATH_RELATIONS.UNKNOWN

    def __init__(self):
        pass

    def __unicode__(self):
        return u"<RelationResult: {}>".format(self.code)


def get_path_relation(path1, path2):
    path1 = [p for p in path1]
    path2 = [p for p in path2]

    first_station = path1[0]
    last_station = path1[-1]
    result = RelationResult()
    # subpath, superpath, subpath_partialy, superpath_partialy, intersection
    if first_station in path2:
        # subpath, subpath_partialy, super_path, super_path_partialy
        if last_station in path2:
            result.start_index = path2.index(first_station)
            result.end_index = path2.index(last_station)
            if path2.index(last_station) > path2.index(first_station):
                subpath = path2[path2.index(first_station):path2.index(last_station) + 1]
                if is_subpath(path1, subpath):
                    if len(path1) == len(path2):
                        result.code = PATH_RELATIONS.EQUAL
                    else:
                        result.code = PATH_RELATIONS.SUB_PATH

                    return result

            else:
                path2.reverse()
                subpath = path2[path2.index(first_station):path2.index(last_station) + 1]
                if is_subpath(path1, subpath):
                    result.code = PATH_RELATIONS.REVERSED_SUB_PATH
                    return result

    first_station = path2[0]
    last_station = path2[-1]
    if first_station in path1:
        # subpath, subpath_partialy, super_path, super_path_partialy
        if last_station in path1:
            result.start_index = path1.index(first_station)
            result.end_index = path1.index(last_station)
            if path1.index(last_station) > path1.index(first_station):
                subpath = path1[path1.index(first_station):path1.index(last_station) + 1]
                if is_subpath(path2, subpath):
                    if len(path1) == len(path2):
                        result.code = PATH_RELATIONS.EQUAL
                    else:
                        result.code = PATH_RELATIONS.SUPER_PATH

                    return result

            else:
                path1.reverse()
                subpath = path1[path1.index(first_station):path1.index(last_station) + 1]
                if is_subpath(path2, subpath):
                    result.code = PATH_RELATIONS.REVERSED_SUPER_PATH
                    return result

    result.code = PATH_RELATIONS.NO_INTERSECTION

    return result


def is_subpath(path1, path2):
    if len(path2) == len(path1):
        not_equal = 0
        for s1, s2 in zip(path1, path2):
            if s1 != s2:
                not_equal += 1

        return not not_equal

    return False
