# -*- coding: utf-8 -*-


class SupplierStation(object):
    real_title = None
    context = None
    additional_info = None
    KEY_DELIMITER = u"$#$"
    latitude = None
    longitude = None

    def __init__(self, title, code, legacy_stations=None):
        self._title = title and title.strip()
        self._code = code and code.strip()

        self.legacy_stations = legacy_stations or []

    def get_code(self):
        return self._code

    def get_title(self):
        return self._title

    @property
    def title(self):
        return self.get_title() or u""

    def get_key_without_context(self):
        return self.KEY_DELIMITER.join(map(unicode, [self.title, self.code]))

    def get_key_with_context(self):
        if self.context:
            return self.KEY_DELIMITER.join(map(unicode, [
                self.code, self.title, self.context.key
            ]))
        else:
            return self.get_key_without_context()

    key = property(get_key_with_context)

    def _get_code(self):
        return self.get_code() or u""

    def _set_code(self, code):
        self._code = code

    code = property(_get_code, _set_code)

    def __hash__(self):
        return hash(self.get_key_with_context())

    def __eq__(self, other):
        return other.get_key_with_context() == self.get_key_with_context()

    def __ne__(self, other):
        return other.get_key_with_context() != self.get_key_with_context()

    def __unicode__(self):
        if self.context:
            return u"<%s: title='%s' code='%s' context='%s'>" % (
                self.__class__.__name__, self.title, self.code, self.context
            )
        else:
            return u"<%s: title='%s' code='%s'>" % (self.__class__.__name__, self.title, self.code)

    def __repr__(self):
        return unicode(self).encode('utf8')
