# -*- coding: utf-8 -*-

"""
@deprecated перенесено в scripts.utils
тут оставлено для совместимости с импортами
"""


from datetime import time, date, datetime

from travel.rasp.admin.scripts.schedule.utils import RaspImportError


class ParseError(RaspImportError):
    pass


def get_time(time_str, silent=False):
    try:
        return time(*map(int, time_str.split(':')))
    except (TypeError, ValueError, AttributeError):
        if silent:
            return None
        else:
            raise ParseError(u"Ошибка разбора времени {}".format(time_str))


def get_date(date_str, silent=False, fmt='%Y-%m-%d'):
    try:
        if fmt == u'%Y-%m-%d':
            return date(*map(int, date_str.split('-')))
        else:
            return datetime.strptime(date_str, fmt).date()
    except (TypeError, ValueError, AttributeError):
        if silent:
            return None
        else:
            raise ParseError(u"Ошибка разбора даты {}".format(date_str))


def get_sql_datetime(dt_str, silent=False):
    format_ = '%Y-%m-%d %H:%M:%S'
    try:
        return datetime.strptime(dt_str, format_)
    except (ValueError, TypeError):
        if silent:
            pass
        else:
            raise ParseError(u"Ошибка разбора даты и времени {} формат {}".format(dt_str, format_))


def get_wsdl_datetime(dt_str):
    format_ = '%Y-%m-%dT%H:%M:%S'
    try:
        return datetime.strptime(dt_str, format_)
    except (ValueError, TypeError):
        raise ParseError(u"Ошибка разбора даты и времени {} формат {}".format(dt_str, format_))
