# coding: utf-8

from pprint import PrettyPrinter


class UnicodePrettyPrinter(PrettyPrinter):
    def format(self, obj, context, maxlevels, level):
        if isinstance(obj, basestring):
            if isinstance(obj, unicode):
                return u"'{}'".format(obj).encode('utf8'), True, False
            else:
                obj = obj.decode('utf8', 'ignore')
                return u"'{}'".format(obj).encode('utf8'), True, False

        return PrettyPrinter.format(self, obj, context, maxlevels, level)


def pprint(obj, stream=None, indent=1, width=80, depth=None):
    """Pretty-print a Python object to a stream [default is sys.stdout]."""
    printer = UnicodePrettyPrinter(
        stream=stream, indent=indent, width=width, depth=depth)
    printer.pprint(obj)


def pformat(obj, indent=1, width=80, depth=None):
    """Format a Python object into a pretty-printed representation."""
    return UnicodePrettyPrinter(indent=indent, width=width, depth=depth).pformat(obj)


def uformat(obj, indent=1, width=80, depth=None):
    """Format a Python object into a pretty-printed representation."""
    return UnicodePrettyPrinter(indent=indent, width=width, depth=depth).pformat(obj).decode('utf8')
