#!/usr/bin/env python
# coding: utf-8

"""Установка флагов maintenance"""

import sys

import travel.rasp.admin.scripts.load_project  # noqa

from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context
from travel.rasp.admin.lib.maintenance.flags import flags


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        if len(sys.argv) != 3 or not sys.argv[2].isdigit():
            print "Usage: %s <flagname> <value>" % sys.argv[0]
            sys.exit(1)

        flag_name = sys.argv[1]
        value = int(sys.argv[2])

        flags[flag_name] = value
