# coding: utf-8
from __future__ import unicode_literals

"""
Скрипт для заполнения ISO-3166-1 alpha-3 кодов стран
"""

import travel.rasp.admin.scripts.load_project  # noqa

import argparse
import json
import logging
import os.path

from common.models.geo import Country
from common.utils.fileutils import get_current_file_dir
from travel.rasp.library.python.common23.logging import log_run_time, create_current_file_run_log
from travel.rasp.admin.lib.logs import print_log_to_stdout, get_script_log_context, ylog_context

log = logging.getLogger(__name__)


def add_country_codes():
    datapath = os.path.join(get_current_file_dir(), 'data', 'country_codes.json')
    with open(datapath, 'rt') as f:
        data = f.read()

    country_infos = json.loads(data)
    country_infos.extend([
        {'name': 'Абхазия', 'alpha-2': 'AB', 'alpha-3': 'ABH'},
        {'name': 'Южная Осетия', 'alpha-2': 'OS', 'alpha-3': 'OST'}
    ])
    for country_info in country_infos:
        code = country_info['alpha-2']
        code3 = country_info['alpha-3']
        try:
            country = Country.objects.get(code=code)
        except Country.DoesNotExist:
            pass
        else:
            country.code3 = code3
            country.save()
            log.info('Записали код %s для страны %s', code3, country)


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        parser = argparse.ArgumentParser()
        parser.add_argument('-v', '--verbose', action='store_true', help=u'выводить лог на экран')

        args = parser.parse_args()

        if args.verbose:
            print_log_to_stdout()

        with log_run_time(u'Прописываем ISO-3166-1 alpha-3 коды стран', logger=log):
            add_country_codes()
