# coding: utf8
"""
Добавляем систему кодирования "РЖД ЕСР", т.к. наш ЕСР и РЖДшный не совпадают.
Добавляем коды станций в этой системе.
"""

import travel.rasp.admin.scripts.load_project  # noqa

import logging

from django.db import transaction

from common.models.geo import CodeSystem, Station, StationCode
from travel.rasp.library.python.common23.logging import log_run_time
from travel.rasp.admin.lib.logs import add_stdout_handler, create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.scripts.single.add_rzd_esr_codes_data import STATION_ID_TO_RZD_ESR

log = logging.getLogger(__name__)


@transaction.atomic
def add_rzd_esr():
    with log_run_time(u'Создаем систему rzd_esr', logger=log):
        rzd_esr_system, created = CodeSystem.objects.get_or_create(id=34, title=u'РЖД ЕСР', code=u'rzd_esr')

    with log_run_time(u'Добавляем {} кодов станций системы rzd_esr'.format(len(STATION_ID_TO_RZD_ESR)), logger=log):
        for i, station in enumerate(Station.objects.only('id')):
            if not (i % 1000):
                log.info(u'{}'.format(i))

            rzd_esr_code = STATION_ID_TO_RZD_ESR.get(station.id)
            if rzd_esr_code:
                StationCode.objects.get_or_create(
                    station=station,
                    code=rzd_esr_code,
                    system=rzd_esr_system,
                )


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()
        add_stdout_handler(log)
        add_rzd_esr()

