# coding: utf-8

"""
RASPEXPORT-171
Скрипт для замены дефисов на тире в названиях ниток.
"""

import travel.rasp.admin.scripts.load_project  # noqa

import logging
from optparse import OptionParser

from django.db import transaction

from common.models.schedule import RThread
from common.models_utils import fetch_related
from common.utils.iterrecipes import chunker
from common.utils.progress import PercentageStatus

from travel.rasp.admin.lib.logs import add_stdout_handler, get_script_log_context, ylog_context
from travel.rasp.admin.lib.mysqlutils import MysqlModelUpdater
from travel.rasp.admin.lib.schedule import fast_get_threads_with_rtstations
from travel.rasp.admin.lib.tmpfiles import clean_temp, get_tmp_dir


log = logging.getLogger(__name__)


@clean_temp
@transaction.atomic
def replace_thread_dash(log):
    log.info(u'Начали перегенерацию названий ниток.')

    titles_fields = [
        'title',
        'title_short'
    ]
    tmp_dir = get_tmp_dir()

    ids_chunk_size = 20000

    thread_ids = list(RThread.objects.exclude(is_manual_title=True).values_list('id', flat=True))
    log.info(u'Нужно обработать %s ниток.', len(thread_ids))
    status = PercentageStatus(len(thread_ids), log)
    with MysqlModelUpdater(RThread, tmp_dir, fields=titles_fields) as title_updater:
        for chunk_ids in chunker(thread_ids, ids_chunk_size):
            threads = fast_get_threads_with_rtstations(RThread.objects.filter(id__in=chunk_ids),
                                                       fetch_stations=True, fetch_settlements=True)
            fetch_related(threads, 'supplier', 't_type', model=RThread)
            for thread in threads:
                thread.gen_title()
                title_updater.add(thread)
                status.step()

    log.info(u'Успешно завершили перегенерацию названий ниток.')


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        optparser = OptionParser()

        optparser.add_option('-v', '--verbose', action='store_true')

        options, args = optparser.parse_args()

        if options.verbose:
            add_stdout_handler(log)

        replace_thread_dash(log)
