# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import travel.rasp.admin.scripts.load_project  # noqa

import argparse
import logging

from django.db import transaction

from common.models.geo import Station
from travel.rasp.library.python.common23.logging import create_current_file_run_log
from travel.rasp.admin.lib.logs import print_log_to_stdout, get_script_log_context, ylog_context


log = logging.getLogger(__name__)


@transaction.atomic()
def main():
    # 977 Крым
    for s in Station.objects.filter(region=977):
        if not s.get_code('express'):
            continue

        express_code = s.get_code('express')
        express_code_ru = s.get_code('express_ru')
        express_code_ua = s.get_code('express_ua')
        log.info('Обрабатываем станцию %s %s: %s ru=%s ua=%s', s.id, s.title, express_code, express_code_ru,
                 express_code_ua)
        codes = set()
        for c in [express_code, express_code_ru, express_code_ua]:
            if c:
                codes.add(c)

        if len(codes) == 3:
            log.error('У станции %s %s три разных кода', s.id, s.title)
            continue

        good_express_ru = next((c for c in codes if c.startswith('20')), None)
        good_express_ua = next((c for c in codes if c.startswith('22')), None)

        if not good_express_ru:
            log.warning('У станции %s %s нет русского кода Эксрпесс-3', s.id, s.title)
            continue
        else:
            if express_code != good_express_ru:
                log.info('Меняем код станции express %s %s с %s на %s', s.id, s.title, express_code, good_express_ru)
                s.set_code('express', good_express_ru)
            if express_code_ru != good_express_ru:
                log.info('Меняем код станции express_ru %s %s с %s на %s', s.id, s.title, express_code_ru,
                         good_express_ru)
                s.set_code('express_ru', good_express_ru)

        if good_express_ua:
            if express_code_ua != good_express_ua:
                log.info('Меняем код станции express_ua %s %s с %s на %s', s.id, s.title, express_code_ua,
                         good_express_ua)
                s.set_code('express_ua', good_express_ua)
        else:
            log.warning('У станции %s %s нет украинского кода Эксрпесс-3', s.id, s.title)
            if express_code_ua:
                log.warning('Удаляем код express_code_ua у станции %s %s', s.id, s.title)
                s.del_code('express_ua')


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        parser = argparse.ArgumentParser()
        parser.add_argument('-v', '--verbose', action='store_true')

        create_current_file_run_log()
        args = parser.parse_args()
        if args.verbose:
            print_log_to_stdout()

        main()
