# coding: utf-8

"""
Скрипт пересчитывает thread.import_uid на новые значения
"""

import travel.rasp.admin.scripts.load_project  # noqa

import logging
from optparse import OptionParser

from django.db import transaction

from common.models.schedule import RThread
from common.models_utils import fetch_related
from common.utils.date import RunMask
from common.utils.iterrecipes import chunker
from common.utils.progress import PercentageStatus
from travel.rasp.admin.lib import tmpfiles
from travel.rasp.admin.lib.logs import add_stdout_handler, create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.lib.mysqlutils import MysqlModelUpdater
from travel.rasp.admin.lib.schedule import fast_get_threads_with_rtstations

log = logging.getLogger(__name__)


@tmpfiles.clean_temp
@transaction.atomic
def regenerate_import_uids():
    log.info(u'Начинаем перегенерацию import_uid для ниток.')

    ids_chunk_size = 20000

    thread_ids = list(RThread.objects.all().values_list('id', flat=True))
    log.info(u'Всего нужно обработать %s ниток', len(thread_ids))

    duplicate_thread_ids = set()
    processed_import_uids = set()
    tmp_dir = tmpfiles.get_tmp_dir()
    status = PercentageStatus(len(thread_ids), log)
    with MysqlModelUpdater(RThread, tmp_dir, fields=['import_uid']) as thread_updater:
        for chunk_ids in chunker(thread_ids, ids_chunk_size):
            threads = fast_get_threads_with_rtstations(RThread.objects.filter(id__in=chunk_ids))
            fetch_related(threads, 'route', model=RThread)
            for thread in threads:
                import_uid = thread.gen_import_uid()
                if import_uid in processed_import_uids:
                    duplicate_thread_ids.add(thread.id)
                else:
                    processed_import_uids.add(import_uid)
                    thread_updater.add(thread)
                status.step()

    log.info(u'Нашли %s ниток-дубликатов.', len(duplicate_thread_ids))
    duplicate_threads = fast_get_threads_with_rtstations(RThread.objects.filter(id__in=duplicate_thread_ids))
    fetch_related(duplicate_threads, 'route', model=RThread)
    status = PercentageStatus(len(duplicate_threads), log)
    for duplicate_thread in duplicate_threads:
        import_uid = duplicate_thread.gen_import_uid()
        main_thread = RThread.objects.get(import_uid=import_uid)
        main_thread.year_days = str(RunMask(main_thread.year_days) | RunMask(duplicate_thread.year_days))
        main_thread.save()
        duplicate_thread.delete()
        status.step()

    log.info(u'Перегенерация import_uid для ниток успешно завершена.')


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        optparser = OptionParser()

        optparser.add_option('-v', '--verbose', action='store_true')

        options, args = optparser.parse_args()

        if options.verbose:
            add_stdout_handler(log)

        regenerate_import_uids()
