#!/usr/bin/env python
# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import travel.rasp.admin.scripts.load_project  # noqa

import os

from django.conf import settings
from django.contrib.sites.models import Site

from travel.rasp.admin.scripts.sitemap.sitemaps.city import CitiesSitemap
from travel.rasp.admin.scripts.sitemap.sitemaps.external_direction import ExternalDirectionSitemap
from travel.rasp.admin.scripts.sitemap.sitemaps.search import SearchAllDaysSitemap, LastochkaSitemap
from travel.rasp.admin.scripts.sitemap.sitemaps.settlement_transport import SettlementTransportSitemap
from travel.rasp.admin.scripts.sitemap.sitemaps.station import StationScheduleSitemap
from travel.rasp.admin.scripts.sitemap.sitemaps.thread import ThreadsSitemap
from travel.rasp.admin.scripts.sitemap.sitemaps.transport import TransportSitemap
from travel.rasp.admin.lib.logs import create_current_file_run_log, print_log_to_stdout, get_script_log_context, ylog_context
from travel.rasp.library.python.sitemap.check import check_sitemaps
from travel.rasp.library.python.sitemap.generate import generate_sitemaps


DESKTOP_SITES = ['rasp.yandex.ru', 'rasp.yandex.by', 'rasp.yandex.ua', 'rasp.yandex.kz', 'rasp.yandex.uz']
TOUCH_SITES = ['t.rasp.yandex.ru', 't.rasp.yandex.by', 't.rasp.yandex.ua', 't.rasp.yandex.kz', 't.rasp.yandex.uz']


def _make_site_sitemaps(site, sitemaps, do_check_sitemaps):
    index_filepath, sitemap_filepaths = generate_sitemaps(
        os.path.join(settings.MEDIA_ROOT, 'root', 'sitemaps', site),
        Site.objects.get(name=site),
        sitemaps
    )
    if do_check_sitemaps:
        check_sitemaps(index_filepath, sitemap_filepaths)


def main(do_check_sitemaps=False):
    sitemaps = {
        'cities': CitiesSitemap,
        'transport': TransportSitemap,
        'city_transport': SettlementTransportSitemap,
        'threads': ThreadsSitemap,
        'station_schedule': StationScheduleSitemap,
        'search_all_days': SearchAllDaysSitemap,
        'lastochka': LastochkaSitemap,
    }

    for site in TOUCH_SITES:
        _make_site_sitemaps(site, sitemaps, do_check_sitemaps)

    sitemaps.update({
        'external_direction': ExternalDirectionSitemap
    })

    for site in DESKTOP_SITES:
        _make_site_sitemaps(site, sitemaps, do_check_sitemaps)


def main_cli():
    import argparse

    create_current_file_run_log()

    parse = argparse.ArgumentParser()
    parse.add_argument('-v', '--verbose', action='store_true')
    parse.add_argument('-c', '--check-sitemaps', action='store_true')

    args = parse.parse_args()
    if args.verbose:
        print_log_to_stdout()

    main(args.check_sitemaps)


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        main_cli()
