# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.utils.http import urlencode

from common.models.geo import Settlement
from travel.rasp.library.python.sitemap.models.common import CommonSitemap


class ExternalDirectionSitemap(CommonSitemap):
    def items(self):
        return [
            (settlement_id, direction_code)
            for settlement_id, direction_code in Settlement.objects.
            exclude(hidden=True).exclude(suburban_zone=None).
            values_list('id', 'suburban_zone__externaldirection__code')
            if direction_code]

    def location(self, obj):
        settlement_id, direction_code = obj
        return '/city/{}/direction?{}'.format(
            settlement_id,
            urlencode({'direction': direction_code})
        )
