# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.models.schedule import RThread
from travel.rasp.library.python.sitemap.models.common import CommonSitemap


class ThreadsSitemap(CommonSitemap):
    def items(self):
        return [thread.canonical_uid for thread in RThread.objects.filter(canonical_uid__startswith='R_')]

    def location(self, thread_uid):
        return '/thread/{}'.format(thread_uid)
