# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.data_api.transport_page.transport_country import get_full_transport_data
from travel.rasp.library.python.sitemap.models.common import CommonSitemap


class TransportSitemap(CommonSitemap):
    def items(self):
        full_data = get_full_transport_data()
        result = []
        for t_type_code in ['plane', 'train', 'suburban', 'bus']:
            if t_type_code in full_data:
                result.append(t_type_code)
        return result

    def location(self, item):
        t_type_code = item
        return '/{}'.format(t_type_code)
