# coding: utf8

from __future__ import unicode_literals, absolute_import, division, print_function

import travel.rasp.admin.scripts.load_project  # noqa

from common.models.schedule import TrainTurnover
from travel.rasp.library.python.common23.logging import create_current_file_run_log
from travel.rasp.admin.importinfo.models.af import AFTrainTurnoverFile
from travel.rasp.admin.importinfo.turnovers import load_turnovers_from_file
from travel.rasp.admin.lib.logs import print_log_to_stdout, get_script_log_context, ylog_context


def run():
    TrainTurnover.objects.all().delete()

    for train_turnover in AFTrainTurnoverFile.objects.all():
        if not train_turnover.loaded:
            load_turnovers_from_file(train_turnover.get_encoded_data(), train_turnover.schedule_file_name)
            train_turnover.loaded = True
            train_turnover.save()


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()
        print_log_to_stdout()
        run()
