# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import json
import logging
import requests
from datetime import timedelta
from optparse import OptionParser

from django.db import transaction

from common.models.partner import BlablacarToken
from travel.rasp.library.python.common23.date import environment

from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.scripts.utils.lock import get_script_lock


log = logging.getLogger(__name__)


BLABLACAR_KEY = 'e573f975e2937bce1c6f3326eecc7ee9b0a1ea89d25e36ec77fe76fbae552186'
BLABLACAR_SECRET = '627d98e2f030c9aff2d890d7442eb421f8b3cf99cfcace02ae3f1444abcf6c62'

BLABLACAR_GET_TOKEN_URL = 'https://api.blablacar.com/oauth/v2/access_token?grant_type=client_credentials'
BLABLACAR_GET_TOKEN_TIMEOUT = 60

# При изменении нужно обновить запуск скрипта в кроне.
# Сейчас интервал в кроне специально сделан в 3 раза меньше
BLABLACAR_TOKEN_EXPIRE_MARGIN_IN_MINUTES = 30


def update_access_token():
    token, expire_msk_dt = get_stored_token_and_expire_msk_dt()

    token_title = get_token_title(token)

    is_expired = is_already_expired(expire_msk_dt)

    if token and not is_expired:
        log.info(u'Токен %s в обновлении не нуждается', token_title)

        return

    elif not token:
        log.info(u'В базе нет токена')

    elif is_expired:
        log.info(u'В базе есть токен %s, но он протух', token_title)

    log.info(u'Получаем новый токен')

    recieve_and_store_new_token()


def get_stored_token_and_expire_msk_dt():
    blablacar_token = BlablacarToken.get_latest_token_or_none()

    if blablacar_token is None:
        return None, None

    return blablacar_token.token, blablacar_token.expire_msk_dt


def recieve_and_store_new_token():
    try:
        token_response = requests.post(
            BLABLACAR_GET_TOKEN_URL,
            auth=(BLABLACAR_KEY, BLABLACAR_SECRET),
            timeout=BLABLACAR_GET_TOKEN_TIMEOUT,
        )

        token_response.raise_for_status()

    except requests.exceptions.RequestException as e:
        log.info(u'Ошибка получения токена: %r', e)

    else:
        token_response_data = json.loads(token_response.content)

        token = token_response_data['access_token']
        expires_in = token_response_data['expires_in']

        log.info(u'Получили новый токен %s, сохраняем его', get_token_title(token))

        store_token(token, expires_in)


@transaction.atomic
def store_token(token, expires_in):
    token_title = get_token_title(token)

    now = environment.now()

    expire_msk_dt = now + timedelta(seconds=expires_in)

    log.info(u'Токен %s действует до %s', token_title,
             expire_msk_dt.strftime('%Y-%m-%d %H:%M:%S'))

    BlablacarToken.objects.create(
        token=token,
        expire_msk_dt=expire_msk_dt,
        receive_msk_dt=now
    )

    log.info(u'Сохранили токен %s', token_title)


def is_already_expired(msk_dt):
    """
    Нужно обновлять токен заранее, зависит от
    частоты запуска скрипта обновления токена в кроне
    """

    if msk_dt is None:
        return True

    expire_margin = timedelta(minutes=BLABLACAR_TOKEN_EXPIRE_MARGIN_IN_MINUTES)

    return msk_dt < environment.now() + expire_margin


def get_token_title(token):
    try:
        return token[:8]

    except TypeError:
        return None


@transaction.atomic
def remove_old_tokens():
    limit_dt = environment.now() - timedelta(days=180)

    BlablacarToken.objects.filter(expire_msk_dt__lt=limit_dt).delete()


def setup_main():
    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    options, args = optparser.parse_args()

    if options.verbose:
        print_log_to_stdout()

    create_current_file_run_log()


if __name__ == '__main__':
    with get_script_lock(), \
            ylog_context(**get_script_log_context()):
        setup_main()

        try:
            update_access_token()
        except Exception:
            log.exception(u'Неизвестная ошибка обновления токена')

        try:
            remove_old_tokens()
        except Exception:
            log.exception(u'Неизвестная ошибка удаления старых токенов')
