# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging

from django.db import transaction

from order.models import QueryBlackList
from travel.rasp.library.python.common23.date import environment
from travel.rasp.admin.lib.maintenance.flags import flags
from travel.rasp.admin.lib.logs import create_current_file_run_log, print_log_to_stdout, get_script_log_context, ylog_context


log = logging.getLogger(__name__)


@transaction.atomic
def main():
    log.info('Update start')

    queryblacklist = QueryBlackList.objects.filter(
        active=True,
        active_to__lt=environment.now().date()
    ).update(active=False)

    log.info('%s rules updated' % queryblacklist)
    log.info('Update done')


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        from optparse import OptionParser

        optparser = OptionParser()
        optparser.add_option('-v', '--verbose', action='store_true')
        optparser.add_option('-m', '--check_maintenance', action='store_true')
        options, args = optparser.parse_args()

        if options.verbose:
            print_log_to_stdout(log)

        try:
            maintenance_flag = flags['maintenance']

            if options.check_maintenance and maintenance_flag:
                log.warning('Maintenance flag detected: %r', maintenance_flag)
            else:
                main()

        except Exception as e:
            log.exception(e.message)
