#!/usr/bin/env python
# coding: utf-8

from optparse import OptionParser

import travel.rasp.admin.scripts.load_project  # noqa

from django.db import connection, transaction

from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context


@transaction.atomic
def main():
    cursor = connection.cursor()
    cursor.execute("UPDATE www_rthread SET reversed_number = REVERSE(route_number)")


usage = u"Usage: python %prog [options]"

# Если файл запустили из консоли парсим параметры и запускаем скрипт
if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        optparser = OptionParser(usage=usage, description=__doc__)
        optparser.add_option('-v', '--verbose', action="store_true",
                             help=u"выводить лог на экран")
        options, args = optparser.parse_args()

        main()
