#!/usr/bin/env python
# coding: utf-8
from __future__ import unicode_literals, division, print_function

import travel.rasp.admin.scripts.load_project  # noqa

import argparse
import logging
import os

from django.conf import settings

from common.db.mds.clients import mds_s3_public_client
from common.utils.metrics import task_progress_report
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context


log = logging.getLogger(__name__)


def main():
    log.info('Загружаем статику в MDS')
    mds_s3_public_client.upload_directory(os.path.join(settings.MEDIA_ROOT, 'data'), 'media/data')
    log.info('Статика загружена в MDS')


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()), task_progress_report('upload_static_to_s3'):
        parser = argparse.ArgumentParser(description=__doc__)
        parser.add_argument('-v', '--verbose', action='store_true', help=u'выводить лог на экран')
        args = parser.parse_args()

        create_current_file_run_log()
        if args.verbose:
            print_log_to_stdout()

        main()
