#!/usr/bin/env python
# coding: utf-8
from __future__ import unicode_literals, division, print_function

import travel.rasp.admin.scripts.load_project  # noqa

import argparse
import logging
import os

from django.conf import settings

from common.db.mds.clients import mds_s3_common_client
from common.utils.metrics import task_progress_report
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.scripts.utils.lock import get_script_lock


log = logging.getLogger(__name__)


def main():
    log.info('Загружаем экспорт в MDS')
    mds_s3_common_client.upload_directory(
        settings.EXPORT_PATH,
        'rasp-export',
        ignore_files=['*.sql.gz', '/public/stations.xml.gz', 't_types_by_geoid.json', 'bus_station_codes.json']
    )
    log.info('Экспорт загружен в MDS')


if __name__ == '__main__':
    with get_script_lock(), \
            ylog_context(**get_script_log_context()), task_progress_report('upload_to_s3'):
        parser = argparse.ArgumentParser(description=__doc__)
        parser.add_argument('-v', '--verbose', action='store_true', help=u'выводить лог на экран')
        args = parser.parse_args()

        create_current_file_run_log()
        if args.verbose:
            print_log_to_stdout()

        main()
