# coding: utf-8

from __future__ import unicode_literals

import travel.rasp.admin.scripts.load_project  # noqa

import argparse
import logging
import os

from django.conf import settings

from travel.rasp.library.python.common23.logging import create_current_file_run_log
from travel.rasp.admin.lib.download_files import download_files
from travel.rasp.admin.lib.logs import print_log_to_stdout, get_script_log_context, ylog_context


log = logging.getLogger(__name__)

MEDIA_DATA_PATH = os.path.join(os.path.abspath(settings.MEDIA_ROOT), 'data')
MEDIA_DATA_URL = 'https://{}/media/data/'.format(settings.PROD_DOMAIN_NAME)


def main(url=None):
    if not url:
        url = MEDIA_DATA_URL

    download_files(url, path=MEDIA_DATA_PATH, cut_dirs=2)


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        parser = argparse.ArgumentParser()
        parser.add_argument('-v', '--verbose', action='store_true')
        parser.add_argument('--url', default=None)

        args = parser.parse_args()
        if args.verbose:
            print_log_to_stdout()

        main(url=args.url)
