# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os

from django.conf import settings

from common.data_api.file_wrapper.projects_configs.admin_mds_utils import (
    MDS_TEMPORARY, MDS_SERVICE_PREFIX,
    get_instance_mds_prefix, get_service_path
)
from common.settings import WorkInstance, ServiceInstance


MDS_RASP_EXPORT = 'rasp-export'
MDS_RASP_MEDIA_EXPORT = 'rasp-media-export'

MDS_SCHEDULE_UPLOAD = 'schedule-upload'

MDS_ADMIN_RUNS_LOG = 'admin-runs-log'
MDS_CRON_RUNS_LOG = 'cron-runs-log'

MDS_RUN_STATES = 'run-states'

DIR_PATH = {
    MDS_RASP_EXPORT: settings.EXPORT_PATH,
    MDS_RASP_MEDIA_EXPORT: os.path.join(settings.MEDIA_ROOT, 'data/export')
}


def get_mds_key(export_type, path=None, force_service=False, force_work=False):
    if force_service:
        service = True
    elif force_work:
        service = False
    else:
        service = settings.INSTANCE_ROLE.code == ServiceInstance.code

    base_path = get_service_path(export_type) if service else export_type
    key = os.path.join(base_path, os.path.relpath(path, DIR_PATH.get(export_type))) if path else base_path
    return key


def get_rasp_export_key(path=None, force_service=False, force_work=False):
    return get_mds_key(MDS_RASP_EXPORT, path, force_service, force_work)


def get_rasp_media_export_key(path=None, force_service=False, force_work=False):
    return get_mds_key(MDS_RASP_MEDIA_EXPORT, path, force_service, force_work)


def get_log_key(log_prefix, log_name):
    return os.path.join(log_prefix, log_name)


def get_admin_log_key(log_name):
    log_prefix = get_instance_mds_prefix(MDS_ADMIN_RUNS_LOG)
    return get_log_key(log_prefix, log_name)


def get_cron_log_key(log_name):
    log_prefix = get_instance_mds_prefix(MDS_CRON_RUNS_LOG)
    return get_log_key(log_prefix, log_name)


def get_run_state_key(state_file):
    state_prefix = get_instance_mds_prefix(MDS_RUN_STATES)
    return os.path.join(state_prefix, state_file)
