# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
import os

from django.conf import settings

from common.data_api.file_wrapper.config import get_wrapper_creator
from common.settings.utils import define_setting
from common.utils.threadutils import Ticker
from travel.rasp.admin.scripts.utils.file_wrapper.registry import FileType
from travel.rasp.admin.scripts.utils.file_wrapper.mds_utils import get_instance_mds_prefix, MDS_TEMPORARY, MDS_SCHEDULE_UPLOAD
from travel.rasp.admin.scripts.utils.import_file_storage import get_schedule_temporary_date_path, get_schedule_temporary_today_dir


log = logging.getLogger(__name__)

ADMIN_MDS_TEMPORARY_URL_TEMPLATE = 'admin/mds_files_viewer/{}'

define_setting('MDS_LOG_UPLOAD_INTERVAL', default=1)


def get_rel_path(dir_path):
    sub_dir_path = os.path.relpath(dir_path, settings.SCHEDULE_TEMPORARY_PATH)
    prefix = get_instance_mds_prefix(MDS_TEMPORARY)
    relative_path = os.path.join(prefix, sub_dir_path)
    return relative_path


def get_temporary_url():
    prefix = get_instance_mds_prefix(MDS_TEMPORARY)
    return ADMIN_MDS_TEMPORARY_URL_TEMPLATE.format(prefix)


def upload_tmp_schedule(supplier_or_package, today=None):
    dir_path = get_schedule_temporary_date_path(supplier_or_package, today)
    relative_path = get_rel_path(dir_path)

    dir_wrapper = get_wrapper_creator(FileType.SCHEDULE_TEMPORARY, relative_path=relative_path).get_file_wrapper(dir_path)
    dir_wrapper.upload()


def delete_tmp_schedule(supplier_or_package, appendix=None, today=None):
    dir_path = get_schedule_temporary_today_dir(supplier_or_package, today)
    relative_path = get_rel_path(dir_path)
    if appendix:
        relative_path = os.path.join(relative_path, appendix)

    dir_wrapper = get_wrapper_creator(FileType.SCHEDULE_TEMPORARY, relative_path=relative_path).get_file_wrapper(dir_path)
    dir_wrapper.delete()


def get_schedule_upload_wrapper(schedule_file):
    prefix = get_instance_mds_prefix(MDS_SCHEDULE_UPLOAD)
    key = os.path.join(prefix, os.path.relpath(schedule_file, settings.SCHEDULE_UPLOAD))
    return get_wrapper_creator(FileType.SCHEDULE_UPLOAD, key=key).get_file_wrapper(schedule_file)


class ObjWrapperSyncer(Ticker):
    def __init__(self, obj_wrapper, interval, *args, **kwargs):
        self.obj_wrapper = obj_wrapper
        super(ObjWrapperSyncer, self).__init__(target=self.upload_obj, interval=interval, *args, **kwargs)

    def upload_obj(self):
        try:
            self.obj_wrapper.upload()
        except Exception:
            log.exception('obj upload failed')

    def stop(self):
        super(ObjWrapperSyncer, self).stop()
        self.upload_obj()

    def __enter__(self):
        self.start()

    def __exit__(self, exc_type, exc_value, traceback):
        self.stop()
        self.join()
