# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import inspect

from django.conf import settings

from common.utils.fileutils import get_my_caller_file
from common.utils.lock import lock


def get_script_lock(script_name=None):
    stack = inspect.stack()
    script_name = script_name or get_my_caller_file(stack).split('.')[0]
    collection_name = '{}_admin'.format(settings.INSTANCE_ROLE.code)
    return lock(script_name, collection_name)
