# coding: utf-8

import sys

import xapian

if len(sys.argv) < 3:
    print >> sys.stderr, "Usage: %s PATH_TO_DATABASE WORDS_FILE" % sys.argv[0]
    sys.exit(1)

keywords = (u'аэропорт/вокзал/поезд/самолет/рейс/электричка/электропоезд/расписание/'
            u'экспресс/аэроэкспресс/скорый/авиа/авиабилет/жд/авиарейс').encode('utf-8').split('/')

geowords = [word.strip() for word in open(sys.argv[2], 'r')]

# Open the database for searching.
database = xapian.Database(sys.argv[1])

# Start an enquire session.
enquire = xapian.Enquire(database)

stemmer = xapian.Stem('russian')

qp = xapian.QueryParser()
qp.set_stemmer(stemmer)
qp.set_database(database)
qp.set_stemming_strategy(xapian.QueryParser.STEM_SOME)

# Попавшиеся запросы
docids = set()

doccount = database.get_doccount()

for counter, word in enumerate(['"%s"' % word for word in geowords] + keywords):
    if counter % 10 == 0:
        print >> sys.stderr, word
        print >> sys.stderr, "%d words, %d matches" % (counter, len(docids))

    counter += 1

    query = qp.parse_query(word)

    # print >> sys.stderr, str(query)

    enquire.set_query(query)
    matches = enquire.get_mset(0, 10000000)  # С потолка, лишь-бы не упало

    # print >> sys.stderr, "%i results found." % matches.size()

    for m in matches:
        docid = m.docid

        # Новый документ
        if docid not in docids:
            # Выводим
            print m.document.get_data()

        docids.add(docid)

    sys.stdout.flush()
