# coding: utf-8

import sys

import xapian

if len(sys.argv) < 2:
    print >> sys.stderr, "Usage: %s PATH_TO_DATABASE" % sys.argv[0]
    sys.exit(1)

keywords = u'аэропорт', u'вокзал'
geowords = (u'шереметьево, домодедово, внуково, пулково, толмачево, кольцово,'
            u' храброво, стригино, емельяново, курумоч').split(', ')

try:
    # Open the database for searching.
    database = xapian.Database(sys.argv[1])

    # Start an enquire session.
    enquire = xapian.Enquire(database)

    stemmer = xapian.Stem('russian')

    query = xapian.Query(xapian.Query.OP_OR, [stemmer(word) for word in keywords] + geowords)

    enquire.set_query(query)
    matches = enquire.get_mset(0, database.get_doccount())

    # Display the results.
    sys.stderr.write("%i results found.\n" % matches.get_matches_estimated())

    for m in matches:
        print m.document.get_data()

except Exception, e:
    print >> sys.stderr, "Exception: %s" % str(e)
    sys.exit(1)
