# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

from common.models.geo import Station


# жд-станции, через которые ходяет пригородные поезда
stations = Station.objects.filter(hidden=False,
                                  t_type__code='train', majority__id__lt=5,
                                  rtstation__thread__route__t_type__code='suburban').distinct()

titles = set()

for station in stations:
    for title in ([station.title, station.title_ru_genitive, station.title_ru_accusative] +
                  [synonym.title for synonym in station.synonyms.all()]):

        if title:
            titles.add(title)

    # города, к которым привязаны эти станции
    settlement = station.settlement

    if settlement:
        for title in ([settlement.title, settlement.title_ru_genitive, settlement.title_ru_accusative] +
                      [synonym.title for synonym in settlement.synonyms.all()]):

            if title:
                titles.add(title)


for title in titles:
    print title.encode('utf-8')
