# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

from urllib import urlencode
from xml.etree import ElementTree

from common.models.geo import Country
from common.utils.http import urlopen
from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context


inflector_url = 'http://export.yandex.ru/inflect.xml'


def inflect(name):
    params = [
        ('name', name.encode('utf-8')),
    ]

    stream = urlopen(inflector_url + '?' + urlencode(params))
    tree = ElementTree.parse(stream)
    stream.close()

    for inflection in tree.findall('inflection'):
        if inflection.get('case') == '2':
            return inflection.text

    return name


def run():
    for country in Country.objects.filter(title_of__isnull=True):
        country.title_of = inflect(country.title)
        country.save()


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        run()

