# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

from itertools import chain

from django.db.models import Q

from common.models.geo import Settlement, Station
from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context
from travel.rasp.admin.www.utils.language import city_preposition_locative


def run():
    conditions = Q(title_ru_preposition_v_vo_na__isnull=True, title_ru_locative__isnull=False)

    empty_settlements = Settlement.objects.filter(conditions)
    empty_stations = Station.objects.filter(conditions)

    for obj in chain(empty_settlements, empty_stations):
        obj.title_ru_preposition_v_vo_na = city_preposition_locative(obj.title_ru_locative)
        obj.save()

if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        run()
