#!/usr/bin/env python
# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging

from django.db.models import Q

from common.models.geo import Station
from travel.rasp.admin.lib.logs import create_current_file_run_log, get_script_log_context, ylog_context


log = logging.getLogger(__name__)


def run():
    log.info(u"Start")
    changed = 0
    stations = Station.objects.filter(Q(station_type=12) | Q(station_type__isnull=True))
    for station in stations:
        new_type = station.determine_station_type()
        if new_type != station.station_type:
            log.debug("Change station type: from '%s' to '%s' (%s)", station.station_type.L_name(),
                      new_type.L_name(), station.id)
            station.station_type = new_type
            station.save()
            changed += 1

        old_title = station.title
        station.modify_title()
        if old_title != station.title:
            log.debug("Rename station: %s -> %s (%s)", (old_title, station.title, station.id))

    log.info(u"Finish. Changed %s stations of %s." % (changed, len(stations)))

if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        run()
