# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

from django.db import transaction

from common.models.schedule import RTStation
from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context


@transaction.atomic
def run():
    RTStation.objects.filter(is_technical_stop=True).update(
        is_searchable_to=False,
        is_searchable_from=False,
        in_station_schedule=False
    )


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        run()
