# coding: utf-8

import sys
import os
import datetime
import socket
from collections import defaultdict

from django.utils.translation import ugettext_lazy as _

from common.settings import *
from common.settings.utils import get_cache_config
from common.settings.configuration import (
    Configuration, MysqlConfigurator, AllMongoDatabasesConfigurator, ReplicaStateCacheConfigurator,
    MiscConfigurator, RaspBackendConfigurator
)


from configuration.rsync import RsyncAdminConfigurator
from configuration.misc import MiscAdminConfigurator


ADMIN_CONFIGURATION_CLASSES = [
    MysqlConfigurator,
    AllMongoDatabasesConfigurator,
    ReplicaStateCacheConfigurator,
    MiscConfigurator,
    MiscAdminConfigurator,
    # RsyncAdminConfigurator,
]


RASP_PROJECT = 'admin'
ALLOWED_HOSTS = ['.yandex-team.ru']
ENVIRONMENT = 'dev'

PROD_SERVICE_URL = 'production.service.admin.rasp.yandex-team.ru'
PROD_WORK_URL = 'production.work.admin.rasp.yandex-team.ru'
TEST_SERVICE_URL = 'testing.service.admin.rasp.in.yandex-team.ru'
TEST_WORK_URL = 'testing.work.admin.rasp.in.yandex-team.ru'

EMAIL_HOST = os.environ.get('RASP_EMAIL_HOST', 'localhost')
EMAIL_SUBJECT_PREFIX = '[Django-rasp@%s] ' % socket.gethostname()
DEFAULT_FROM_EMAIL = 'rasp-tech@yandex-team.ru'
SERVER_EMAIL = 'Rasp at %s <rasp-tech@yandex-team.ru>' % socket.gethostname()

EMAIL_BACKEND = 'django.core.mail.backends.dummy.EmailBackend'
EMAIL_TIMEOUT = 30
REDIRECT_EMAILS = ['devnull@yandex-team.ru']

DEBUG = False
DEBUG_PROPAGATE_EXCEPTIONS = False


try:
    import pwd
    current_user = ('Current User', '%s@yandex-team.ru' % pwd.getpwuid(os.getuid())[0])
except Exception:
    username = os.environ.get('USERNAME', os.environ.get('LOGNAME'))
    if username:
        current_user = ('Current User', '%s@yandex-team.ru' % username)
    else:
        current_user = ('Current User', 'devnull@yandex-team.ru')

CURRENT_USER_NAME = current_user[1]


ADMINS = (
    ('Martyugin Pavel', 'martuginp@yandex-team.ru'),
)

MANAGERS = ADMINS

TABLO_ERROR_RCPNTS = (('Rasp tablo errors', 'rasp-tablo-errors@yandex-team.ru'),)
PROCESS_RCPNTS = (('Rasp process', 'rasp-process@yandex-team.ru'),)
TRAIN_IMPORT_RCPNTS =(('Rasp train import', 'rasp-train-import@yandex-team.ru'),)
DATACHANGE_RCPNTS = (('Data mail list', 'rasp-scripts-data@yandex-team.ru'),)
RASP_FREE_STATIONS_RCPNTS = (('Rasp free stations list', 'rasp-free-stations@yandex-team.ru'),)
UNKNOWN_CODES_RCPNTS = (('Unknown Codes list', 'rasp-unknown-codes@yandex-team.ru'),)
EXPERSS_SUBST_RCPNTS = (('Express subst list', 'rasp-experss-subst@yandex-team.ru'),)

ERRORS_RECIPIENTS = ['rasp-errors@yandex-team.ru']

# Основные директории проекта
PROJECT_PATH = os.path.dirname(sys.executable)
SCRIPTS_PATH = os.path.normpath(os.path.join(PROJECT_PATH, 'scripts'))
EXPORT_PATH = os.path.join(PROJECT_PATH, 'www/db/scripts/export')
EXPORT_PUBLIC_PATH = os.path.join(EXPORT_PATH, 'public')
EXPORT_SUBURBAN_PATH = os.path.join(EXPORT_PATH, 'suburban')
DATA_PATH = os.path.join(PROJECT_PATH, 'www/db/scripts/data')
SHARED_DATA_BASE_PATH = '/var/lib/yandex-rasp-admin-data'
SCHEDULE_TEMPORARY_PATH = os.path.join(DATA_PATH, 'schedule', 'temporary')
SCHEDULE_UPLOAD = os.path.join(DATA_PATH, 'upload')

CONF_FILE = os.path.join(PROJECT_PATH, 'metadata', 'conf')

# Db Settings
IS_BLANK_TEST_DB = False
MYSQL_READ_TIMEOUT = MYSQL_WRITE_TIMEOUT = 3600 * 5  # для особо долгих скриптов
PING_MYSQL_BEFORE_EACH_REQUEST = True
MAINTENANCE_DB_CRITICAL = True

# FIXME: Тоже дублируются в коммоне, но под другими именами
BILLING_HOST = 'mbi1gt.market.yandex.net'  # хост биллинга
BILLING_PORT = 34861             # порт
BILLING_SERVICE_ID = 114         # номер нашего сервиса в биллинге

# отправлять ли уведомления об изменениях времени рейса
SEND_CHANGES_REMINDERS = False
# хост для отправки уведомлений
REMINDERS_HOST = 'reminders-api.tardis.dev.yandex.net'

SERVICE_INSTANCE = os.getenv('RASP_SERVICE_INSTANCE', None) == 'true'
WORK_INSTANCE = os.getenv('RASP_WORK_INSTANCE', None) == 'true'

assert not (SERVICE_INSTANCE and WORK_INSTANCE)

if not SERVICE_INSTANCE:
    WORK_INSTANCE = True

if SERVICE_INSTANCE:
    INSTANCE_ROLE = ServiceInstance
elif WORK_INSTANCE:
    INSTANCE_ROLE = WorkInstance


MIGRATION_PRJ_VERSION = 11

CACHES = {
    'default': get_cache_config(['localhost'])
}


PRELOAD_MAPPING_GEOMETRY = True

TIME_ZONE = 'Europe/Moscow'

USE_I18N = True
# Для нормальной работы админки
USE_L10N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = os.path.join(PROJECT_PATH, 'media')

DEFAULT_FILE_STORAGE = "travel.rasp.library.python.common23.models.fields.storage.TransliteratingFileSystemStorage"
FILEBROWSER_DIRECTORY = 'data/static/'
FILEBROWSER_VERSIONS_BASEDIR = 'data/_fb_versions/'
FILEBROWSER_ADMIN_VERSIONS = ['admin_thumbnail']
FILEBROWSER_VERSIONS = {
    'admin_thumbnail': {'verbose_name': 'Admin Thumbnail', 'width': 80, 'height': 80, 'opts': 'crop'}
}

# Make this unique, and don't share it with anybody.
SECRET_KEY = '6sm82tff48ajyfl6l+zwv4hbjp%8@iyynp*g6kn^mvb5ikdf5e'

DATA_UPLOAD_MAX_NUMBER_FIELDS = 10000

STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
    'library.python.django.contrib.staticfiles.finders.ArcadiaAppFinder'
]

TEMPLATES = [
    # TODO: удалить после отладки
    # {
    #     'BACKEND': 'django.template.backends.django.DjangoTemplates',
    #     'DIRS': [],
    #     'APP_DIRS': True,
    #     'OPTIONS': {
    #         'debug': False,
    #         'context_processors': [
    #             'django.contrib.auth.context_processors.auth',
    #             'django.template.context_processors.debug',
    #             'django.template.context_processors.media',
    #             'django.template.context_processors.request',
    #             'django.template.context_processors.static',
    #             'django.contrib.messages.context_processors.messages',
    #             'www.context.default',
    #             'admin.context_processors.admin'
    #         ]
    #     },
    # },
    {
        'BACKEND': 'library.python.django.template.backends.arcadia.ArcadiaTemplates',
        'OPTIONS': {
            'debug': False,
            'loaders': [
                'library.python.django.template.loaders.resource.Loader',
                'library.python.django.template.loaders.app_resource.Loader',
            ],
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                'django.template.context_processors.media',
                'django.template.context_processors.static',
                'travel.rasp.admin.www.context.default',
                'travel.rasp.admin.admin.context_processors.admin'
            ],
        },
    }
]

FORM_RENDERER = 'library.python.django.template.backends.forms_renderer.ArcadiaRenderer'

JINJA_EXTS = ['jinja2.ext.i18n']

JINJA_CONTEXT_PROCESSORS = (
    'django.template.context_processors.debug',
    'django.template.context_processors.media',
    'django.template.context_processors.request',
    'travel.rasp.admin.www.context.default',
)

JINJA_LIBRARIES = (
    'travel.rasp.admin.www.templatetags.common',
    'travel.rasp.admin.www.templatetags.durations',
    'travel.rasp.admin.www.templatetags.html',
)

JINJA_GLOBALS = (
    '__builtin__.min',
    '__builtin__.reversed',
    'datetime.timedelta',
    # 'django_russian.utils.qadjective',
    # 'django_russian.utils.qnoun',
    # 'django_russian.utils.qverb',
    'itertools.chain',
    'math.floor',
    'math.ceil',
    'pytils.numeral.get_plural',
    'random.randint',
)

JINJA_FILTERS = (
    'django.template.defaultfilters.capfirst',
    'django.template.defaultfilters.date',
    'django.template.defaultfilters.urlencode',
    # 'django_russian.templatetags.russian.human_date',
    # 'django_russian.templatetags.russian.human_duration',
    # 'django_russian.templatetags.russian.quantity',
    'pytils.templatetags.pytils_dt.ru_strftime',
)

JINJA_TEMPLATE_DIRS = [
    os.path.join(PROJECT_PATH, 'templates/jinja')
]


MIDDLEWARE_CLASSES = (
    'travel.rasp.admin.admin.middleware.idm_tvm.IdmTvmMiddleware',

    'common.middleware.request_activator.RequestActivator',
    'common.middleware.syncdb.SyncDB',
    'common.middleware.now.Now',

    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.middleware.gzip.GZipMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.security.SecurityMiddleware',

    'travel.rasp.admin.lib.mda.MDAMiddleware',
    'travel.rasp.admin.www.middleware.AdminAuth',
    'travel.rasp.admin.www.middleware.Language',

    'travel.rasp.admin.admin.middleware.on_switch_db.CustomMessageInAdminOn500WhenSwitchDB'
)

ROOT_URLCONF = 'urls'

INSTALLED_APPS = (
    # 'django_russian',
    # Сторонние приложения
    'pytils',

    'travel.rasp.library.python.common23.db.mongo',
    'common',
    'travel.rasp.library.python.common23.models.texts',
    'travel.rasp.library.python.common23.models.tariffs',
    'travel.rasp.library.python.common23.models.transport',
    'travel.rasp.library.python.common23.models.core',

    # Локальные приложения
    'staticpages',
    'travel.rasp.admin.www',
    'travel.rasp.admin.importinfo',
    'currency',
    'tariffs_admin',
    'promosearch',
    'order',
    'cysix',
    'stats',
    'suburban_change_notices',
    'api',
    'travel.rasp.admin.timecorrection',
    'www_extra',
    # Дополнения к админке
    'travel.rasp.admin.admin',
    'travel.rasp.admin.admin.www_stations',
    'travel.rasp.admin.admin.blue',
    'travel.rasp.admin.admin.red',
    'travel.rasp.admin.admin.lime',
    'travel.rasp.admin.admin.maintenance_settings',

    # Общие модули
    'common.maintenance',
    'common.xgettext',
    'common.apps.facility',
    'common.apps.info_center',
    'common.apps.train',
    'common.apps.train_order',
    'common.apps.suburban_events',
    'geosearch',
    'route_search',
    'stationschedule',
    'mapping',
    'tester',
    'travel.rasp.library.python.sitemap',

    'admins.common_apps.facility_admins',
    'admins.common_apps.suburban_events_admins',
    'admins.common_apps.train_admins',
    'admins.common_apps.train_order_admins',

    # Чтобы работали переопределения шаблонов, django нужно включать позже
    'filebrowser',
    'django_yauth',
    'django.contrib.staticfiles',
    'django.contrib.auth',
    'django.contrib.admin',
    'django.contrib.humanize',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django_idm_api',
)


LOGIN_URL = '/admin/'

try:
    from django_yauth.settings import *
    YAUSER_ADMIN_LOGIN = True

    YAUTH_TYPE = 'intranet'
    YAUTH_BACKEND = 'blackbox'

    import blackbox

except ImportError:
    pass


VERSION_FILE = '/version'
if os.path.exists(VERSION_FILE):
    PKG_VERSION = open(VERSION_FILE).readline().strip()
else:
    PKG_VERSION = datetime.datetime.today().strftime('dev.%Y%m%d%H%M%S')

# URL that handles the media served from MEDIA_ROOT.
# Example: "http://media.lawrence.com"
MEDIA_URL = '/media/'
MARKUP_URL = '/static/markup/'

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".

STATIC_URL = '/static/'

CACHEROOT = '/yandex/rasp-service/{}/'.format(PKG_VERSION)


STATIC_ROOT = os.path.join(PROJECT_PATH, 'static/')

DISABLE_PRECACHE = True

RSYNC = '/usr/bin/rsync'

PATHFINDER_TIMEOUT = .5

FILE_UPLOAD_PERMISSIONS = int('644', 8)

DISABLE_YAUTH = False

# Настройки танкера
TANKER_KEYSETS = {
    'admin': ('admin/locale', ['ru', 'en'])
}


ADMIN_LANGUAGES = ['ru', 'en']

MODEL_LANGUAGES = ['ru', 'en', 'tr', 'uk']  # Добавлен английский, fallback для турецких названий


# keep ASC order by period weight
SERVICEMETRICS_PERIODS = ['hour', 'day', 'month', 'year']
SERVICEMETRICS_SERVICES = {
    'ticket': u'Авиабилеты',
    'rasp': u'Расписания',
}

# Джанговские настройки для языков
# Language code for this installation. All choices can be found here:
# http://www.w3.org/TR/REC-html40/struct/dirlang.html#langcodes
# http://blogs.law.harvard.edu/tech/stories/storyReader$15
LANGUAGE_CODE = 'ru'

BASE_LANGUAGE = 'ru'

CLEAN_TMP = True

PAGES_ROOT = os.path.join(os.path.dirname(sys.executable), 'static/markup/pages-desktop')

PROD_DOMAIN_NAMES = {
    ServiceInstance.code: PROD_SERVICE_URL,
    WorkInstance.code: PROD_WORK_URL
}
PROD_DOMAIN_NAME = PROD_DOMAIN_NAMES[INSTANCE_ROLE.code]

LOG_URL_PATHS = defaultdict(lambda: '/admin/logs/')
LOG_URL_PATH = LOG_URL_PATHS[INSTANCE_ROLE.code]

DOMAIN_NAMES = {
    ServiceInstance.code: 'rasp-service.admin.{}'.format(socket.gethostname()),
    WorkInstance.code: 'rasp-migration.admin.{}'.format(socket.gethostname()),
}
PATHFINDER_URLS = {
    ServiceInstance.code: 'http://localhost:8102/search',
    WorkInstance.code: 'http://localhost:8101/search',
}
INSTANCE_PATHS = {
    ServiceInstance.code: '/opt/yandex/yandex-rasp-service',
    WorkInstance.code: '/opt/yandex/yandex-rasp-admin'
}
LOG_PATHS = {
    ServiceInstance.code: '/var/log/yandex-rasp-service',
    WorkInstance.code: '/var/log/yandex-rasp-admin'
}
CACHE_PATHS = {
    ServiceInstance.code: '/var/cache/yandex-rasp-service/',
    WorkInstance.code: '/var/cache/yandex-rasp-admin/'
}

PATHFINDER_URL = PATHFINDER_URLS[INSTANCE_ROLE.code]
LOG_PATH = LOG_PATHS[INSTANCE_ROLE.code]
DOMAIN_NAME = DOMAIN_NAMES[INSTANCE_ROLE.code]
CACHE_PATH = CACHE_PATHS[INSTANCE_ROLE.code]


ADMIN_TASK_RUN_IN_SEPARATE_PROCESS = True


SERIALIZATION_MODULES = {
    'test_yaml': 'tester.yaml_serializer',
    'json': 'common.utils.django_utils.utf8_json_serializer'
}

YT_PROXY = 'hahn.yt.yandex.net'

YT_SEARCH_LOG_PATH = '//home/rasp/logs/'
YT_ROOT_PATH = '//home/rasp/rasp/min_price'

LOG_LEVEL_NAME = 'INFO'

IDM_INSTANCE = 'production'

from managed_settings import *
from order.settings import *
ENVIRONMENT_NOW = None  # datetime


import configure_logs
configure_logs.configure_logs(globals(), LOG_PATH, LOG_LEVEL_NAME)

CACHE_BACKEND = 'dummy://'
PROJECT_CODE = 'rasp_admin'

AVIA_NATIONAL_VERSIONS = ['ru', 'ua', 'tr', 'com']

MORDA_LINK = "localhost"
