(function() {

var BaseHandler, handlers;

BaseHandler = $.inherit({

    __constructor: function(param) {
        this.param = param;
    },

    filters: function(value) {
        return !this.passes(value);
    },

    update: function(data) {},

    updateOptions: function(data) {}

});

handlers = {

    simple: $.inherit(
        BaseHandler,
        {
            __constructor: function(block, elem, params) {

                this.__base.call(this, params.param);

                this.restrict = params.restrict;

                this.block = block;

                this.menu = block.findBlockInside(elem, 'b-menu-vert-mod');

                this.checkboxes = block.findBlocksInside(elem, 'b-form-checkbox');

                BEM.afterCurrentEvent(function() {

                    BEM.blocks['b-form-checkbox'].on(elem, 'change', function() {
                        block.trigger('filter');
                    });

                });

            },

            update: function() {

                this.selected = $.map(this.checkboxes, function(checkbox) {

                    return checkbox.isChecked() ? checkbox.val() : undefined;

                });

                return this.selected.length ? this.selected : null;

            },

            passes: function(value) {

                var selected = this.selected,
                    restrict = this.restrict;

                if(!selected.length)
                    return true;

                if(!value)
                    return true;

                if($.isArray(value)) {
                    for(var i = 0; i < value.length; i++) {
                        if(restrict) {
                            if($.inArray(value[i], selected) == -1)
                                return false;
                        } else
                            if($.inArray(value[i], selected) != -1)
                                return true;
                    }

                    return restrict;
                } else {
                    return $.inArray(value, selected) != -1;
                }

            },

            updateOptions: function(data) {

                var _this = this,
                    good = {},
                    active = {},
                    activeCount = 0;

                $.each(data, function() {

                    if(this.value) {

                        // Учитываем только элементы, не отфильтрованные другими фильтрами

                        if(this.filteredBy.length == 0 || (this.filteredBy.length == 1 && this.filteredBy[0] == _this)) {

                            if($.isArray(this.value)) {

                                $.each(this.value, function(i, v) {
                                    good[v] = true;
                                });

                            } else {
                                good[this.value] = true;
                            }

                        }

                        if($.isArray(this.value)) {

                            $.each(this.value, function(i, v) {
                                active[v] = true;
                            });

                        } else {
                            active[this.value] = true;
                        }

                    }

                });

                $.each(this.checkboxes, function(i, checkbox) {

                    var val = checkbox.val();

                    if(val in active) {
                        _this.showOption(i);

                        activeCount++;
                    }

                    if(val in good)
                        checkbox.delMod('grayed-out');
                    else
                        checkbox.setMod('grayed-out', 'yes');

                });

                activeCount = $.map(active, function() { return true; }).length;

                if(activeCount > 1)
                    this.show();

            },

            showOption: function(i) {

                var unit = this.menu.elem('layout-unit').eq(i);

                unit.removeClass('i-hidden');

            }

        }
    )

};

BEM.DOM.decl('b-filter', {

    onSetMod: {

        js: function() {

            var _this = this,
                menu = this.findBlockInside('b-menu-vert-mod'),
                unitSelector = menu.buildSelector('layout-unit');

            this.elem('form')[0].reset();

            this.filters = this.elem('filter').map(function(i) {

                var elem = $(this),
                    params = _this.elemParams(elem),
                    Handler = handlers[params.handler],
                    filter = new Handler(_this, elem, params);

                filter.show = function() {

                    elem.closest(unitSelector).removeClass('i-hidden');

                    _this.domElem.removeClass('i-hidden');
                    _this.domElem.prev().removeClass('i-hidden'); // b-filter-title

                };

                return filter;

            });

        }

    },

    filter: function(objects, dataFunc) {

        var filters = this.filters,
            params = {},
            filtered = [],
            visible = [];

        // Обновляем данные в фильтрах в соответствие с выбором пользователя
        filters.each(function(i, f) {
            params[f.param] = f.update();
        });

        this.findBlockOutside('b-page').trigger('change-params', params);

        // Фильтрация
        $.each(objects, function(i, obj) {

            var filteredBy = [],
                data = dataFunc(obj);

            obj['b-filter:data'] = {
                filteredBy: filteredBy,
                data: data
            };

            filters.each(function (i, f) {

                if(f.filters(data[f.param])) {
                    filteredBy.push(f);
                }

            });

            if(filteredBy.length)
                filtered.push(obj);
            else {
                visible.push(obj);
            }

        });

        // Дизейблим пункты, которых нет в профильтрованных сегментах
        filters.each(function(i, f) {

            var updateData = $.map(objects, function(obj) {

                var data = obj['b-filter:data'];

                return {
                    filteredBy: data.filteredBy,
                    value: data.data[f.param]
                };

            });

            f.updateOptions(updateData);

        });

        return {
            filtered: filtered,
            visible: visible
        };

    }

}, {

    BaseHandler: BaseHandler

});

})();
