BEM.DOM.decl({ name : 'b-form-input', modName : 'pick', modVal : 'yes' }, {

    onSetMod : {

        'js' : function() {
            var _this = this,
                keyInput = this.elem('key');

            this.link = null; // ссылка на все варианты внизу саггеста

            this.params.dataprovider.input = this;

            this.__base.apply(this, arguments);

            this._keyInput = keyInput.length ? keyInput : $('<input type="hidden" name="' + this.params['key-name'] + '" />').appendTo(this.domElem);

            this.bindTo('more', 'click', function() {

                this._preselected = { key : this.keyVal(), text : this.val() };

                this.val(this._enteredVal);

                this.setMod('focused', 'yes');

                this._doRequest();

            });

            this.on('data-received', function(e, data) {

                this._enteredVal = this.val();

                if(data.length > 1)
                    this.delMod(this.elem('more'), 'visibility');
                else
                    this.setMod(this.elem('more'), 'visibility', 'hidden');

            });

            this.on('update-items', function() {

                if(_this._preselected)
                    $.each(this._metaItems, function(i) {

                        if(this[0] && this[0] == _this._preselected.key || this[1] == _this._preselected.text)
                            _this._onEnterItem(_this._items[i]);

                    });

                this.del('_preselected');

            });

            this.on('change', function(e, data) {

                if(!(data && data.source == 'autocomplete'))
                    this.keyVal('');

            });

        }

    },

    _onKeyPress : function(e) {

        if(e.keyCode == 13) {
            e.preventDefault();

            this.trigger('doRedraw');
        }

        this.__base.call(this, e);
    },

    _doRequest : function() {

        var _this = this,
            reqVal = _this.val();

        _this.enablePopup();
        _this._userVal = _this.val();

        _this
            .trigger('data-requested')
            .getDataprovider().get(
                reqVal,
                function(data) {
                    if(reqVal != _this.val()) // Опоздали
                        return;

                    _this.trigger('data-received', data);

                    var popup = _this._getPopup(),
                        dataItems = data.items || data;

                    _this.foot && dataItems.length && ($.inArray(_this.foot, dataItems) == -1) && dataItems.push(_this.foot);

                    if(dataItems.length) {
                        _this._curItemIndex = -1;
                        BEM.DOM.update(popup.elem('items'), _this._buildItemsHtml(dataItems), function() {
                            _this._updatePopupPos();
                            _this._items = popup.findBlocksInside('b-autocomplete-item');
                            _this.trigger('update-items');
                        });
                    } else {
                        popup.hide();
                    }
                });

    },

    _buildItemsHtml : function(data) {

        this._metaItems = data;

        var _this = this;

        data = $.map(data, function(item) {
            return item[2];
        });

        // добавляем ссылку на все варианты в конец саггестов
        if (this.link) {

            var title = BEM.I18N('b-rasp-search', 'show-all-title-choices');

            if(title)
                data.push(['foot', '<a class="b-link" href="' + this.link + '">' + title  + '</a>']);

        }

        return this.__base.call(this, data);

    },

    val : function(val, data) {

        if(data && data.source == 'autocomplete') {

            var item = this._metaItems[data.itemIndex],
                key = item[0];

            val = item[1];

            this.keyVal(key);

            // Уточнение не окончательно, продолжаем
            !key && val != this.val() && this._doRequest();

        }

        if(data && data.preventRequest && !this._preventRequest) {
            this._preventRequest = true;

            this.afterCurrentEvent(function() {
                this.del('_preventRequest');
            });
        }

        val = this.__base.call(this, val, data);

        // Показать кнопку "ещё варианты", если они есть
        //if(data && data.source == 'sample') {

            //this.getDataprovider().get(
                //val,
                //function(data) {
                    //this.trigger('data-received', data);
                //}
            //);

        //}

        return val;

    },

    keyVal : function(val) {

        if(typeof val == 'undefined')
            return this._keyInput.val();

        this._keyInput.val(val);

        this.trigger('keyChange');

        return this;

    },

    _setValFromSample : function(elem) {

        if(!this.hasMod('disabled', 'yes')) {
            var params = this.__self.extractParams(elem[0]);
            this.val('val' in params? params.val : elem.text(), { source : 'sample' });
            for (var i in params)
                if (params[i].value)
                    this.keyVal(params[i].value || '');
        }

    },

    _getState : function() {

        return {

            val: this.val(),
            keyVal: this.keyVal(),
            more: this.getMod(this.elem('more'), 'visibility') != 'hidden',
            _enteredVal: this._enteredVal,
            _preselected: this._preselected

        };

    },

    _setState : function(state) {

        this._enteredVal = state._enteredVal;
        this._preselected = state._preselected;

        this.val(state.val, { preventRequest: true });
        this.keyVal(state.keyVal);

        if(state.more) {
            this.delMod(this.elem('more'), 'visibility');
        } else {
            this.setMod(this.elem('more'), 'visibility', 'hidden');
        }

    }

});
