(function() {

BEM.DOM.decl({name: 'b-i-timetable', modName: 'informer', modVal: 'station'}, {

    onSetMod: {

        js: function() {

            BEM.blocks['b-page'].on('change-tz', this._onTimeZoneChange, this);

            this.__base.apply(this, arguments);
        }
    },

    _onTimeZoneChange: function(e, tz) {
        this.redrawDates();
    },

    redrawDates: function() {

        var _this = this;

        $.each(['dep', 'arr'], function(i, ttype) {
            var times = _this.elem('row')
                    .not('.i-hidden')
                    .find(_this.buildSelector('cell', 'time', ttype))
                    .find(_this.buildSelector('time')),
            prev;

            times.each(function(i, time) {

                var $time = $(time),
                    displayTime = _this.findBlockOn($time, 'i-time').displayTime(),
                    html;

                html = BEM.blocks['i-time'].formatTime('time-strong-date-if-changed', displayTime, prev);

                $time.html(html);

                prev = displayTime;
            });
        });
    }

});

})();
