BEM.DOM.decl('b-linkthis', {
    onSetMod: {
        'js': {
            'inited': function() {
                this.bindTo(this.elem('next'), 'click', this.onNextMonth);
                this.bindTo(this.elem('prev'), 'click', this.onPrevMonth);
            }
        }
    },
    getCurrent: function() {
        return this.elem('calendar').filter(':not(.i-hidden)');
    },
    onNextMonth: function(e) {
        e.preventDefault();

        var current = this.getCurrent(),
            next = current.next(this.buildSelector('calendar')),
            nextNext = next.next(this.buildSelector('calendar')).length;

        current.addClass('i-hidden');
        next.removeClass('i-hidden');
        this.elem('prev').removeClass('i-hidden');
        if(!nextNext)
            this.elem('next').addClass('i-hidden');
        this.elem('month-name').html(next.attr('data-month-name'));
    },
    onPrevMonth: function(e) {
        e.preventDefault();

        var current = this.getCurrent(),
            prev = current.prev(this.buildSelector('calendar')),
            prevPrev = prev.prev(this.buildSelector('calendar')).length;

        current.addClass('i-hidden');
        prev.removeClass('i-hidden');
        this.elem('next').removeClass('i-hidden');
        if(!prevPrev)
            this.elem('prev').addClass('i-hidden');
        this.elem('month-name').html(prev.attr('data-month-name'));
    },
    redraw: function(current, active) {
        // FIXME: это работает только для страницы заказа билета
        var activeDict = {},
            self = this,
            currentDate = ru_strftime(current, '%Y-%m-%d');

        $.each(active, function(i, d) {
            activeDict[ru_strftime(d, '%Y-%m-%d')] = true;
        });

        function typeName(mark, holiday, dark) {
            return $.map(['mark', 'holiday', 'dark'], function(s) {
                return eval(s) ? [s] : [];
            }).join('-');
        };

        this.elem('day').each(function() {
             var $day = $(this),
                 date = $day.attr('data-date');

             if(date) {
                 var type = self.getMod($day, 'type').split('-'),
                     holiday = $.inArray('holiday', type) != -1,
                     day = $day.text();

                 if(date in activeDict) {
                     var link = Schedule.Utils.getParams(window.location, {date: date});
                     self.setMod($day, 'type', typeName(true, holiday, true));
                     $day.html('<div class="b-calendar__day__i"><a class="b-link" href="' + link + '">' + day + '</a></div>');
                     // FIXME: хак, пока не знаю, как сделать лучше
                     Schedule.Utils.openLink($day.find('a')[0]);
                 } else {
                     self.setMod($day, 'type', typeName(false, holiday, false));
                     $day.html('<div class="b-calendar__day__i">' + day + '</div>');
                 }

                 if(date == currentDate)
                     self.setMod($day, 'state', 'current');
                 else
                     self.delMod($day, 'state');
             }
        });
    }
});
