BEM.DOM.decl('b-page-calendar', {
    onSetMod: {
        'js': {
            'inited': function() {
                this.bindTo(this.elem('arrow', 'type', 'prev'), 'click', this.onPrevMonth);
                this.bindTo(this.elem('arrow', 'type', 'next'), 'click', this.onNextMonth);
            }
        }
    },
    getSelector: function() {
        return this.buildSelector('calendar');
    },
    getCurrent: function() {
        return this.elem('calendar', 'state', 'current');
    },
    onNextMonth: function(e) {
        e.preventDefault();

        var current = this.getCurrent(),
            next = current.next(this.getSelector()),
            nextNext = next.next(this.getSelector()).length;

        this.setMod(current, 'state', 'hidden');
        this.setMod(next, 'state', 'current');

        this.delMod(this.elem('arrow', 'type', 'prev'), 'state', 'hidden');
        if(!nextNext)
            this.setMod(this.elem('arrow', 'type', 'next'), 'state', 'hidden');
        this.elem('month-name').html(next.attr('data-month-name'));
    },
    onPrevMonth: function(e) {
        e.preventDefault();

        var current = this.getCurrent(),
            prev = current.prev(this.getSelector()),
            prevPrev = prev.prev(this.getSelector()).length;

        this.setMod(current, 'state', 'hidden');
        this.setMod(prev, 'state', 'current');

        this.delMod(this.elem('arrow', 'type', 'next'), 'state', 'hidden');
        if(!prevPrev)
            this.setMod(this.elem('arrow', 'type', 'prev'), 'state', 'hidden');
        this.elem('month-name').html(prev.attr('data-month-name'));
    },
    redraw: function(current, active) {
    // TODO
    }
//        function(current, active) {
//        // FIXME: это работает только для страницы заказа билета
//        var activeDict = {},
//            self = this,
//            currentDate = ru_strftime(current, '%Y-%m-%d');
//
//        $.each(active, function(i, d) {
//            activeDict[ru_strftime(d, '%Y-%m-%d')] = true;
//        });
//
//        function typeName(mark, holiday, dark) {
//            return $.map(['mark', 'holiday', 'dark'], function(s) {
//                return eval(s) ? [s] : [];
//            }).join('-');
//        };
//
//        this.elem('day').each(function() {
//             var $day = $(this),
//                 date = $day.attr('data-date');
//
//             if(date) {
//                 var type = self.getMod($day, 'type').split('-'),
//                     holiday = $.inArray('holiday', type) != -1,
//                     day = $day.text();
//
//                 if(date in activeDict) {
//                     var link = Schedule.Utils.getParams(window.location, {date: date});
//                     self.setMod($day, 'type', typeName(true, holiday, true));
//                     $day.html('<div class="b-page-calendar__day__i"><a class="b-link" href="' + link + '">' + day + '</a></div>');
//                     // FIXME: хак, пока не знаю, как сделать лучше
//                     Schedule.Utils.openLink($day.find('a')[0]);
//                 } else {
//                     self.setMod($day, 'type', typeName(false, holiday, false));
//                     $day.html('<div class="b-page-calendar__day__i">' + day + '</div>');
//                 }
//
//                 if(date == currentDate)
//                     self.setMod($day, 'state', 'current');
//                 else
//                     self.delMod($day, 'state');
//             }
//        });
//    }
});
