(function() {

function copyInputs($oldForm, $newForm) {
    $oldForm.find('input').each(function(i) {
        var $newInput = $newForm.find('input').eq(i);

        if($newInput.hasClass('b-form-input__input'))
           $newInput.closest('.b-form-input').bem('b-form-input').val($(this).val(), {source: 'suggest'});
        else
           $newInput.val($(this).val());
    });
}

BEM.DOM.decl({ name : 'b-page', modName : 'type', modVal : 'informer' }, {

    onSetMod : {

        'js' : function() {

            this.__base.apply(this, arguments);

            var _this = this;

            BEM.blocks['b-form-radio'].on('change', function(e, data) {
                var input = data.current.find('input'),
                    handler = this[input.attr('name')];

                handler && handler.call(this, input.attr('value'));
            }, this);

            this.findBlockInside('b-color-selector').on('color', this._onChangeBackground, this);
            this.findBlockInside('b-informer-color').on('color', this._onChangeColor, this);

            $.each(this.findBlocksInside({ blockName : 'b-form-input', modName : 'pick', modVal : 'yes' }), function() {

                this.on('doRedraw', function() {

                    if(this.keyVal())
                        _this.redraw();

                });

            });

            $('#ext-preview').load(function() {
                //        $(this).attr('height', $((this.contentDocument || this.contentWindow.document).body).height());
                _this.genCode();
            });
        }
    },

    'informer-type' : function(type) {

        var $types = $('.js-schedule, .js-tablo, .js-aeroexpress, .js-trip');

        $types.addClass('i-hidden');
        $types.find('form').addClass('i-hidden');

        var block = $('.js-' + type),
            radio = block.find('.b-form-radio__button_checked_yes'),
            val = radio.find('input').val();

        block.removeClass('i-hidden');

        if (val)
            block.find('form.js-' + type + '-' + val).removeClass('i-hidden');
        else
            block.find('form:first').removeClass('i-hidden');
    },

    'schedule-type' : function(type) {

        var $oldForm = $('form:not(.i-hidden)'),
            $newForm,
            $scheduleTypes = $('.js-schedule-any, .js-schedule-train, .js-schedule-suburban, .js-schedule-bus, .js-schedule-sea');

        $scheduleTypes.addClass('i-hidden');

        $('.js-schedule-' + type).removeClass('i-hidden');

        $newForm = $('form:not(.i-hidden)');

        copyInputs($oldForm, $newForm);

        this.redraw();

    },

    'trip-type' : function(type) {

        var $newForm,
            $tripTypes = $('.js-trip-any, .js-trip-plane, .js-trip-train, .js-trip-suburban, .js-trip-bus, .js-trip-sea'),
            $oldForm = $tripTypes.filter(':not(.i-hidden)');

        $oldForm.addClass('i-hidden');

        $newForm = $('.js-trip-' + type).removeClass('i-hidden');

        copyInputs($oldForm, $newForm);

        this.redraw();

    },

    'trip-rows' : function() {

        this.redraw();

    },

    'size' : function(size) {

        this.redraw();

    },

    _onChangeBackground : function(e, color) {

        var block = $(this.findBlockInside({block: 'b-informer-new', modName: 'change', modVal: 'background' }).domElem);

        block.find('.b-informer-new__under-informer').css('background-color', '#' + color.hex);

    },

    _onChangeColor : function(e, color) {

        this.redraw();

    },

    redraw : function() {

        var _this = this,
            $form = $('form:not(.i-hidden)'),
            params = {},
            base = 'http://' + window.location.host + '/informers/',
            path,
            url;

        if(!$form.length)
            return;

        if($form.attr('data-informer') == 'station') {
            var stationId = $form.find('[name=station]').val().substr(1);

            if(!stationId.length)
                stationId = $form.attr('data-type') == "tablo" ? 9600215 // Внуково
                    : 9744832; // Москва (Автостанция Красногвардейская)

            path = 'station/' + stationId + '/';
        } else {
            params = {
                fromId: $form.find('[name=fromId]').val(),
                toId: $form.find('[name=toId]').val()
            };

            if(!params.fromId.length || !params.toId.length)
                params = {
                    fromId: 'c11508', // Стамбул
                    toId: 's9600213'  // Шереметьево
                };

            path = 'search/';
        }

        $.extend(params, {
            size: _this.findBlockInside({ blockName : 'b-form-radio', modName : 'type', modVal : 'size' }).val(),
            color: $('.b-informer-color__item_state_current').attr('data-color')
        });

        if($form.attr('data-type'))
            params['type'] = $form.attr('data-type');

        url = base + path + '?' + $.param(params, true);

        $('#ext-preview').attr('src', url);

    },

    genCode : function() {

        var $iframe = $('#ext-preview'),
            width = $iframe.attr('width'),
            height = $iframe.attr('height'),
            url = $iframe.attr('src'),
            area = $iframe.parent().parent().next().find('.code'),
            style = $iframe.attr('style'),
            code;

        if (style.charAt(style.length - 1) != ';')
            style += ';';

        if (height) {
            style += ' height: ' + height + 'px;';
        }

        code = ('<iframe frameborder="0" ' +
                'style="-moz-box-shadow: 0 2px 3px rgba(0, 0, 0, 0.5); -webkit-box-shadow: 0 2px 3px rgba(0, 0, 0, 0.5); box-shadow: 0 2px 3px rgba(0, 0, 0, 0.5); ' + style + '" ' +
                'src="' + url.replace(/&/g, '&amp;') + '"></iframe>');

        if (!area.length) {
            $(this).parent().append('<br><textarea class="code" cols="87" rows="10"></textarea>');
            area = $(this).parent().find('.code');
            area.val(code);
        } else {
            area.val(code);
        }

        if (area.length) {
            area.val(code);
        }
    }

});

})();
