(function() {

var AJAX = BEM.blocks['i-ajax'],
    URL = BEM.blocks['i-url'];

BEM.DOM.decl({ name : 'b-pricetable', modName : 'type', modVal : 'train'}, {

    onSetMod : {

        'js' : function() {

            var _this = this;

            this.__base.apply(this, arguments);

            this._form = this.findBlockOutside('b-form');

            this.__self.liveBindTo('row', 'click', function(e) {

                var radio = e.data.domElem.find(this.buildSelector('radio'));

                if(radio.length) {
                    radio.attr('checked', 'checked');

                    this._onChange(radio);
                }

            });

            this.__self.liveBindTo('radio', 'change', function(e) {
                this._onChange(e.data.domElem);
            });

            if(this.getMod('incomplete') == 'yes') {
                this.startAjaxUpdates();
            } else {
                this.fetchSchema();
            }

        }

    },

    fetchSchema: function() {

        var _this = this,
            checked = this.elem('radio').filter('[checked]'),
            coach, row, preview;

        if(!checked.length)
            return;

        coach = URL.parseQuery(checked.val()).coach,
        row = checked.closest(this.buildSelector('row')),
        preview = this.findElem(row, 'cell', 'type', 'preview');

        if(this.getMod(preview, 'async') == 'yes' && !this.hasMod(preview, 'retrieving')) {
            this.setMod(preview, 'retrieving', 'yes');

            var params = $.extend({}, URL.parseQuery(window.location.search), {
                coach: coach
            });

            BEM.DOM.update(preview, BEMHTML.apply({ 'block': 'b-candy' }));

            AJAX.progress(function(finish) {

                $.ajax({
                    url: 'options/',
                    data: $.param(params, true),
                    dataType: 'json',
                    timeout: 5000,
                    success: function(response, textStatus) {
                        if(response == 'error') {
                            BEM.DOM.update(preview, '');

                            finish();
                        } else if(response == 'retrieving') {

                        } else {
                            BEM.DOM.update(preview, BEMHTML.apply(response.preview));

                            var schemaRow = response['schema-row'];

                            if(_this.getChoice().coach !== coach) {
                                schemaRow.mix.push({ block: 'i-hidden'});
                            }

                            BEM.DOM.after(row, BEMHTML.apply(schemaRow));

                            _this.dropElemCache();

                            finish();
                        }
                    }
                });

            });
        }

    },

    startAjaxUpdates: function() {

        var _this = this;

        AJAX.progress(function(finish) {

            $.ajax({
                url: 'options/' + window.location.search,
                dataType: 'json',
                timeout: 5000,
                success: function (response, textStatus) {

                    if(response == 'error') {
                        window.location = window.location;
                    } else if(response == 'retrieving') {
                    } else {
                        $.each(response, function(i, row) { row.block = 'b-pricetable'; });

                        BEM.DOM.update(_this.elem('body'), BEMHTML.apply(response));

                        _this.dropElemCache();

                        _this._form.summ.domElem.removeClass('i-hidden');

                        _this.fetchSchema();

                        finish();
                    }
                }
            });

        });

    },

    getOpenSchema : function() {

        var schemaRow = this.elem('row', 'type', 'details').not('.i-hidden');

        return this.findBlockInside(schemaRow, 'b-preview-train-big');

    },

    getChoice : function() {

        return URL.parseQuery(this.elem('radio').filter('[checked]').val());

    },

    _onChange : function(checked) {

        this.fetchSchema();

        this.delMod(this.elem('row'), 'selected');

        var row = checked.closest(this.buildSelector('row')),
            next = row.next(),
            data = row[0].onclick && row[0].onclick();

        if(data && !this.hasMod(next, 'type', 'details')) {
            this._form.trigger('selectSeats', {});
        }

        this.setMod(row, 'selected', 'yes');

        this.elem('row', 'type', 'details').addClass('i-hidden');

        if(this.hasMod(next, 'type', 'details') && next.hasClass('i-hidden')) {

            next.removeClass('i-hidden');

            var offset = row.offset();

            if(offset.top < $(window).scrollTop())
                window.scrollTo($(window).scrollLeft(), offset.top);

            this.findBlockInside(next, 'b-preview-train-big').trigger('show');
        }

    }

});

})();
