BEM.decl('b-rasp-search__dataprovider', {

    onSetMod : {

        'js' : function() {

            this._form = this.params.input.findBlockOutside(this.params.form || 'b-rasp-search');
            this._cache = {};
            this._links_cache = {};

        }
    },

    get: function(val, onSuccess) {

        var when = '';

        if (this._form.when)
            when = this._form.when.val().toLowerCase();

        var _this = this,
            url = this._form.domElem.attr('action') + 'suggests/' + this.params.field + '/?callback=?',
            params = {
                fromName: (this._form.from.val() || '').toLowerCase(),
                fromId: this._form.from.keyVal(),
                toName: (this._form.to.val() || '').toLowerCase(),
                toId: this._form.to.keyVal(),
                when: when
            },
            cacheKey = url + '&' + $.param(params, true);

        if(cacheKey in this._cache) {
            if (cacheKey in this._links_cache) {
                _this.trigger('showSuggestFoot', _this._links_cache[cacheKey]);
            }

            onSuccess.call(this.params.callbackCtx, this._cache[cacheKey]);
            return;
        }

        $.getJSON(url, params, function(data) {

            _this._cache[cacheKey] = data[1];
            _this._links_cache[cacheKey] = data[2];

            _this.trigger('showSuggestFoot', data[2]);

            onSuccess.call(_this.params.callbackCtx, data[1]);

        });

    }

});
