(function() {

var URL = BEM.blocks['i-url'],
    AJAX = BEM.blocks['i-ajax'];


BEM.DOM.decl({ block: 'b-timetable', modName: 'ajax', modVal: 'yes' }, {

    onSetMod: {

        js: function() {

            this.__base.apply(this, arguments);

            var _this = this,
                info = this.params['ajax-info'];

            if(info === undefined)
                return;

            AJAX.progress(function(finish) {

                if(info.k.length == 0)
                    return;

                var params = {
                    d: info.d,
                    k: info.k,
                    ts: JSON.stringify(info.ts),
                    r: JSON.stringify(info.r)
                };

                if(info.b) {
                    params['b'] = info.b;
                };

                $.ajax({
                    url: 'tariffs/',
                    data: $.param(params, true),
                    dataType: 'json',
                    traditional: true,
                    timeout: 5000,
                    success: function (response, textStatus) {
                        _this.ajaxUpdate(info, response) && finish();
                    }
                });

            }, function() {

                $.each(info.k, function(i, key) {
                    _this.removeSpinners(key);
                });

            });

        }

    },

    removeSpinners: function(requestKey) {

        // Наверное так быстрее
        this.domElem.find(BEM.blocks['b-spin'].buildSelector('request-key', requestKey)).remove();

        // Правильный(?) вариант
        // $.each(
        //     this.findBlocksInside({ block: 'b-spin', modName: 'request-key', modVal: requestKey }),
        //     function(spin) { spin.delMod('progress'); }
        // );

    },

    ajaxUpdate: function(info, response) {

        var _this = this,
            bemjson = [{ block: 'i-global', params: BEM.blocks['i-global']._params }].concat(response.segments),
            html = BEMHTML.apply(bemjson),
            newRows;

        $.extend(info.r, response['new-segments']);

        newRows = this.splitRows($(html));

        this.initSort();

        this.rows.split = this.rows.split.map(function(i, row) {

            var key = row.key;

            if(key in newRows.data) {
                $(_this.rows.data[key].domRows).remove();

                return null;
            }

            return row;

        });

        Array.prototype.push.apply(this.rows.split, $.makeArray(newRows.split));

        $.extend(this.rows.data, newRows.data);

        this.rows.split = this.rows.split.map(function(i, row) {

            var key = row.key;

            if(key in response.updates) {
                row.subPlace && row.subPlace.remove();

                return null;
            }

            return row;

        });

        $.each(response.updates, function(key, update) {

            var rowData = _this.rows.data[key];

            if(update['et-marker'])
                $(rowData.domRows).find(_this.buildSelector('eticket')).removeClass('i-hidden');

            $.each(rowData.domRows, function(i, row) {
                _this.filterValues(row, update['filter-values']);
            });

            $.each(update.places, function(i, bemjson) {

                var html = BEMHTML.apply(bemjson),
                    place = $(html),
                    row = {
                        key: key,
                        subPlace: place,
                        subPlaceIndex: _this.elemParams(place).index
                    };

                place.find('a[href]').each(function(i) {

                    var a = $(this),
                        href = a.attr('href'),
                        baseUrl = rowData.baseUrl,
                        newUrl = URL.changeParams(baseUrl, URL.parseQuery(href));

                    a.attr('href', newUrl);

                });

                BEM.DOM.init(place);

                _this.rows.split.push(row);

            });

        });

        this.sort();

        this.filter(); // Включает redrawDates

        info.ts = response.ts;

        // Убираем завершенные ключи
        info.k = $.map(info.k, function (d) {
            return $.inArray(d, response.complete) == -1 ? d : null;
        });

        $.each(response.complete, function(i, key) {
            _this.removeSpinners(key);
        });

        if(info.k.length == 0) {
            return true;
        }

        return false;

    }

});

})();
