(function() {

BEM.DOM.decl({ block: 'b-timetable', modName: 'filter', modVal: 'yes' }, {

    onSetMod: {

        js: function() {

            this.__base.apply(this, arguments);

            var _this = this,
                showHidden;

            this.initGoneFilter();

            this._filter = this.findBlockInside($('body'), { block: 'b-filter' });

            this._filter.on('filter', this.filter, this);

        }

    },

    initGoneFilter: function() {

        var _this = this,
            showHidden = this.elem('show-hidden'),
            links;

        if(!showHidden.length) {
            return;
        }

        links = this.findBlocksInside(showHidden, 'b-link');

        this.hideGone = links[1].hasMod('visibility', 'hidden'); // Скрыть ушедшие

        $.each(links, function(i, link) {

            link.on('click', function() {

                $.each(links, function(i, link) { link.toggleMod('visibility', 'hidden'); });

                _this.hideGone = links[1].hasMod('visibility', 'hidden'); // Скрыть ушедшие

                _this.filter();

            });

        });

    },

    filterValues: function(row, newValues) {

        row = $(row);

        var values = row.data('filter-values');

        if(values === undefined) {

            values = this.elemParams(row)['filter-values'];

            row.data('filter-values', values);

        }

        $.extend(values, newValues);

        return values;

    },

    filter: function() {

        this.initSort();

        var _this = this,
            rows,
            data,
            visible,
            filtered,
            visibleGone,
            visibleNotGone,
            goneSelector = this.buildSelector('row', 'gone', 'yes');

        rows = $.map(this.rows.data, function(data) {
            return data.domRows;
        });

        Array.prototype.push.apply(rows, $.makeArray(this.elem('row', 'fixed', 'yes')));

        data = this._filter.filter(rows, function(row) {
            return _this.filterValues(row);
        });

        visible = $(data.visible).removeClass('i-hidden');

        filtered = $(data.filtered).addClass('i-hidden');

        visibleGone = visible.filter(goneSelector);
        visibleNotGone = visible.not(goneSelector);

        // фильтр ушедших
        this.elem('show-hidden')[visibleGone.length && visibleNotGone.length ? 'removeClass' : 'addClass']('i-hidden');

        if(this.hideGone) {

            // Скрываем ушедшие, если есть ещё неушедшие
            if(visibleGone.length && visibleNotGone.length) {

                visibleGone.addClass('i-hidden');

                visible = visibleNotGone;

                filtered = filtered.add(visibleGone);

            }

        }

        this.updateRows(this.mergeRows());

        visible.next(this.detailsSelector).removeClass('i-hidden');
        filtered.next(this.detailsSelector).addClass('i-hidden');

        this.redrawDates();

        this.setNotesVisibility({

            'e-ticket': this.findElem(visible, 'eticket').not('.i-hidden').length,
            'bottom-return-link': visible.length > 4,
            'filtered-out':  !visible.length

        });

    }

});

})();
