(function() {

var URL = BEM.blocks['i-url'],
    TIME = BEM.blocks['i-time'];

// function timeWithDateIfChangedFormatter(dt, prev) {

//     var showDate = !prev || !TIME.dateEqual(dt, prev),
//         dtCopy = new Date(dt.getTime()); // not fuzzy,

//     return [
//         dt.fuzzy && { elem: 'tilde' },
//         { tag: 'strong', content: TIME.formatTime('time', dtCopy) },
//         showDate && [ ', ', TIME.formatTime('date', dtCopy) ]
//     ];

// };

// function timeFormatter(dt, prev) {

//     var dtCopy = new Date(dt.getTime()); // not fuzzy

//     return [
//         dt.fuzzy && { elem: 'tilde' },
//         { tag: 'strong', content: TIME.formatTime('time', dtCopy) }
//     ];

// };

BEM.DOM.decl('b-timetable', {

    onSetMod: {

        js: function() {

            BEM.blocks['b-page'].on('change-tz', this._onTimeZoneChange, this);

            this.dateFormat = this.params.mode == 'schedule' ? 'time-strong' : 'time-strong-date-if-changed';

            this.timecolumns = this.params['timecolumns'] || [ 'departure', 'arrival' ];

            this.description = this.findBlockInside($('body'), 'b-small-description');

            this.detailsSelector = this.buildSelector('row', 'details', 'yes');

            BEM.blocks['b-page'].on('change-params', function(e, params) {

                var _this = this;

                $.each(params, function(name, value) {

                    if(name == 'details__add' || name == 'details__remove') {

                        var rows = _this.elem('row', 'key', value),
                            baseRows = rows.prev();

                        function hideShowDetails(hideLabel, showLabel, o) {

                            var elem = o.elem || 'details',
                                triggers = _this.findElem(baseRows, elem + '-trigger'),
                                url = triggers.find('a').attr('href');

                            if(name == 'details__add') {

                                _this.setMod(triggers, 'state', 'current');

                                _this.delMod(rows, 'visibility');

                                if(o.modName)
                                    _this.setMod(baseRows, o.modName, o.modVal);

                                BEM.DOM.update(triggers, BEMHTML.apply({

                                    block: 'b-link',
                                    mods: { pseudo: 'yes', 'change-params': 'yes' },
                                    js: { params: { 'details__remove': value } },
                                    url: URL.changeParams(url, params),
                                    content: hideLabel

                                }));

                            } else if(name == 'details__remove') {

                                _this.delMod(triggers, 'state');

                                _this.setMod(rows, 'visibility', 'hidden');

                                if(o.modName)
                                    _this.delMod(baseRows, o.modName);

                                BEM.DOM.update(triggers, BEMHTML.apply({

                                    block: 'b-link',
                                    mods: { pseudo: 'yes', 'change-params': 'yes' },
                                    js: { params: { 'details__add': value } },
                                    url: URL.changeParams(url, params),
                                    content: showLabel

                                }));

                            }

                        }

                        if(_this.getMod(baseRows, 'transfers') == 'yes') {
                            hideShowDetails(
                                BEM.I18N('b-timetable', 'hide-routes'), BEM.I18N('b-timetable', 'show-routes'),
                                {
                                    modName: 'type',
                                    modVal: 'opened'
                                }
                            );
                        } else {
                            hideShowDetails(BEM.I18N('b-timetable', 'hide-details'), BEM.I18N('b-timetable', 'show-details'), { elem: 'times' });
                        }

                    }

                });

            }, this);
        }

    },

    setNotesVisibility: function(visibilities) {

        var notesBlock = this.notesBlock,
            showBlock;

        if(notesBlock === undefined) {
            notesBlock = this.notesBlock = this.findBlockInside($('body'), { block: 'b-static-text', modName: 'type', modVal: 'timetable-notes' });
        }

        $.each(visibilities, function(code, visible) {

            var note = notesBlock.elem('note', 'type', code);

            note[visible ? 'removeClass' : 'addClass']('i-hidden');

        });

        showBlock = this.notesBlock.elem('note').not('.i-hidden').length;

        notesBlock.domElem[showBlock ? 'removeClass' : 'addClass']('i-hidden');

    },

    _onTimeZoneChange: function(e, tz) {

        this.elem('days').addClass('i-hidden');

        this.elem('days', 'tz', String(tz)).removeClass('i-hidden');

        this.redrawDates();

    },

    redrawDates: function() {

        var _this = this,
            innerTables,
            foreignRows,
            rows = _this.findElem('row').not(this.detailsSelector),
            thisRows,
            visibleRows;

        innerTables = $(_this.findBlocksInside('b-timetable')).map(function() {

            if(this === _this)
                return undefined;

            return this.elem('row');

        });

        foreignRows = innerTables.map(function() { return $.makeArray(this); });

        thisRows = rows.not(foreignRows);

        visibleRows = thisRows.not('.i-hidden');

        $.each(this.timecolumns, function(i, column) {

            var times = visibleRows
                    .find(_this.buildSelector('cell', 'type', column))
                    .find(_this.buildSelector('time')),
                prev;

            times.each(function() {

                var blocks = $(_this.findBlocksOn($(this), 'i-time'));

                blocks.each(function() {

                    var displayTime,
                        dtCopy,
                        html;

                    displayTime = this.displayTime();

                    dtCopy = new Date(displayTime.getTime()); // not fuzzy

                    html = TIME.formatTime(_this.dateFormat, dtCopy, prev);

                    if(displayTime.fuzzy)
                        html = '<span class="b-timetable__tilde">~</span>' + html;

                    $(this.domElem).html(html);

                    prev = displayTime;

                });

            });

        });

    }

});

})();
