(function() {

    function csrfSafeMethod(method) {
        // these HTTP methods do not require CSRF protection
        return (/^(GET|HEAD|OPTIONS|TRACE)$/.test(method));
    }

    $.ajaxSetup({
        crossDomain: false, // obviates need for sameOrigin test
        beforeSend: function(xhr, settings) {
            if (!csrfSafeMethod(settings.type)) {
                var csrftoken = $.cookie('csrftoken');

                xhr.setRequestHeader("X-CSRFToken", csrftoken);
            }
        }
    });


    BEM.DOM.decl('b-validate-form', {

        onSetMod: {

            js: function () {
                var validationForm = this.domElem;
                var pane = this.findBlockInside('b-tabbed-pane');
                var validationResult = $('.b-validate');
                var spin = $('.wait-for-result');

                validationForm.on('submit', function (event) {

                    validationResult.empty();
                    spin.show();

                    var id = pane.getTab('state', 'current').prop('id');

                    var options = {
                        type: 'POST',
                        url: 'validate/',
                        data: {'current-tab': id},
                        timeout: 60000,
                        target:  validationResult,
                        success: function(){ spin.hide(); }
                    };

                    validationForm.ajaxSubmit(options);

                    return false;
                });
            }

        }
    });

})();
