$(function() {
    var marks = {};

    $('.geometry_log_row').hover(function() {
        $(this).addClass('hover');
        marks[$(this).attr('data-id')].options.set('preset', 'islands#yellowStretchyIcon');
    }, function() {
        $(this).removeClass('hover');
        marks[$(this).attr('data-id')].options.set('preset', 'islands#blackStretchyIcon');
    });

    $('.b-scheme').each(function () {
        var $schema = $(this),
            cursorPos = {
                x: 0,
                y: 0
            },
            rectStart = null,
            move = false,
            cellMapping,
            width, height,
            elementor = function() {
                var byImg = {},
                    byType = {};

                $.each([
                    ['c', '-', 'rl'],
                    ['c', '|', 'tb'],
                    ['c', '7', 'rb_c'],
                    ['c', '9', 'bl_c'],
                    ['c', '5', 'trbl'],
                    ['c', '1', 'tr_c'],
                    ['c', '3', 'tl_c'],
                    ['c', '6', 'trb'],
                    ['c', '4', 'tbl'],
                    ['c', '8', 'rbl'],
                    ['c', '2', 'trl'],
                    ['c', 't', 'b_f'],
                    ['c', 'b', 't_f'],
                    ['c', 'l', 'r_f'],
                    ['c', 'r', 'l_f'],

                    /*
                     ['c', '84', 'r_f'],
                     ['c', '86', 'l_f'],
                     ['c', '82', 't_f'],
                     ['c', '88', 'b_f']
                     */

                    ['s1', '0', 'tb_s'],
                    ['s1', '100', 'rl_s', 'item_r'],
                    ['s1', '8', 'b_s'],
                    ['s1', '2', 't_s'],
                    ['s1', '108', 'brl_s'],
                    ['s1', '102', 'trl_s'],
                    ['s1', '4', 'tbl_s'],
                    ['s1', '1', 'tr_s'],
                    ['s1', '3', 'tl_s'],
                    ['s1', '7', 'rb_s'],
                    ['s1', '9', 'bl_s'],
                    ['s1', '5', 'trbl_s'],
                    ['s1', '6', 'trb_s'],

                    ['s2', '110', 'rl_s1'],
                    ['s2', '10', 'tb_s1'],
                    ['s2', '18', 'b_s1'],
                    ['s2', '12', 't_s1'],
                    ['s2', '118', 'brl_s1'],
                    ['s2', '112', 'trl_s1'],
                    ['s2', '14', 'tbl_s1'],
                    ['s2', '11', 'tr_s1'],
                    ['s2', '13', 'tl_s1'],
                    ['s2', '17', 'rb_s1'],
                    ['s2', '19', 'bl_s1'],
                    ['s2', '15', 'trbl_s1'],
                    ['s2', '16', 'trb_s1'],

                    ['s3', '120', 'rl_m1'],
                    ['s3', '20', 'tb_m1'],
                    ['s3', '28', 'b_m1'],
                    ['s3', '22', 't_m1'],
                    ['s3', '128', 'brl_m1'],
                    ['s3', '122', 'trl_m1'],
                    ['s3', '24', 'tbl_m1'],
                    ['s3', '21', 'tr_m1'],
                    ['s3', '23', 'tl_m1'],
                    ['s3', '27', 'rb_m1'],
                    ['s3', '29', 'bl_m1'],
                    ['s3', '25', 'trbl_m1'],
                    ['s3', '26', 'trb_m1'],

                    ['s4', '130', 'rl_m'],
                    ['s4', '30', 'tb_m'],
                    ['s4', '38', 'b_m'],
                    ['s4', '32', 't_m'],
                    ['s4', '138', 'brl_m'],
                    ['s4', '132', 'trl_m'],
                    ['s4', '34', 'tbl_m'],
                    ['s4', '31', 'tr_m'],
                    ['s4', '33', 'tl_m'],
                    ['s4', '37', 'rb_m'],
                    ['s4', '39', 'bl_m'],
                    ['s4', '35', 'trbl_m'],
                    ['s4', '36', 'trb_m']
                ], function(i, e) {
                    var type = e[0],
                        img = e[2],
                        cs = img.split('_')[0],
                        mask = 0,
                        obj;

                    $.each("trbl", function(i, c) {
                        if(cs.indexOf(c) != -1)
                            mask |= Math.pow(2, i);
                    });

                    obj = {
                        type: type,
                        img: img,
                        mask: mask
                    };

                    byImg[img] = obj;

                    (type in byType ? byType[type] : byType[type] = {})[mask] = obj;
                });

                $schema.find('.b-scheme__item img').each(function() {
                    var parts = this.src.split('/'),
                        file = parts[parts.length - 1],
                        img = file.split('.')[0],
                        obj = byImg[img];

                    $(this).data('obj', obj);
                });

                this.fixItems = function(items) {
                    var self = this;

                    items.each(function () {
                        self.fixItem($(this));
                    });
                };

                this.fixItem = function(item) {
                    var obj = item.find('img').data('obj'),
                        label = item.find('span');

                    item.removeClass('b-scheme__item_type_right b-scheme__item_type_out-right b-scheme__item_type_out-left');
                    label.removeClass('b-scheme__direction b-scheme__station');

                    if(obj) {
                        switch(obj.img) {
                        case 'r_f':
                            item.addClass('b-scheme__item_type_out-right');
                            break;
                        case 'l_f':
                            item.addClass('b-scheme__item_type_out-left');
                            break;
                        case 't_f':
                        case 'b_f':
                            item.addClass('out');
                            break;
                        }

                        if(obj.img.indexOf('f') != -1)
                            label.addClass('b-scheme__direction');
                        else
                            label.addClass('b-scheme__station');

                        if(obj.img.indexOf('r') != -1)
                            item.addClass('b-scheme__item_type_right');
                    }
                };

                this.changeItem = function(item, obj) {
                    if(obj === null) {
                        item.html('').removeClass('out out_r out_l item_r');
                        return;
                    }

                    var imgUrl = staticUrl + 'i/b-scheme/' + obj.img + '.png';

                    item.find('img').attr('src', imgUrl).length || item.html('<img src="' + imgUrl + '" alt="" />');

                    item.find('img').data('obj', obj);

                    fixItem(item);
                };

                this.addConnection = function (item, c) {
                    var cMask = Math.pow(2, 'trbl'.indexOf(c)),
                        obj = item.find('img').data('obj'),
                        newObj;

                    if(!obj) {
                        newObj = byType['c'][cMask];
                    } else {
                        newObj = byType[obj.type][obj.mask | cMask];
                    }

                    this.changeItem(item, newObj);
                };

                this.removeConnection = function (item, c) {
                    var cMask = Math.pow(2, 'trbl'.indexOf(c)),
                        obj = item.find('img').data('obj');

                    if(obj) {
                        var newMask = obj.mask & ~cMask,
                            newObj = byType[obj.type][newMask];

                        if(newObj) {
                            this.changeItem(item, newObj);
                        }
                    }
                };

                this.changeType = function(item) {
                    var obj = item.find('img').data('obj'),
                        types = ['s1', 's2', 's3', 's4'];

                    if(obj) {
                        var newType = types[($.inArray(obj.type, types) + 1) % types.length],
                            newObj = byType[newType][obj.mask];

                        this.changeItem(item, newObj);
                    }
                };

                return this;
            }();


        $schema.find('.b-scheme__item').live('click', function(e) {
            moveCursorTo($(this).data('coords'));

            return false;
        });

        function mapCells() {
            cellMapping = $schema.find('.b-scheme__row').map(function(y) {
                return $('.b-scheme__item', this).map(function (x) {
                    $(this).data('coords', {
                        x: x,
                        y: y
                    });

                    return this;
                });
            });

            width = cellMapping[0].length;
            height = cellMapping.length;
        }

        mapCells();

        function $cell(x, y, grow) {
            if(y >= height && grow) {
                var newRow = $('<div class="b-scheme__row g-line" />').appendTo($schema.children(':last'));

                cellMapping[height] = [];

                for(var i = 0; i < 31; i++) {
                    cellMapping[height][i] = $('<div class="b-scheme__item" />').appendTo(newRow).data('coords', {
                        x: i,
                        y: height
                    });
                }

                height += 1;

                return $(cellMapping[y][x]);
            }

            if (x < 0 || x >= width ||
                y < 0 || y >= height)
                return $();

            return $(cellMapping[y][x]);
        };

        function $cursor() {
            return $cell(cursorPos.x, cursorPos.y);
        }

        function moveCursorTo(c) {
            $cursor().removeClass('cursor');
            cursorPos = c;
            $cursor().addClass('cursor');
        }

        $cursor().addClass('cursor');

        function rectEach(c1, c2, callback) {
            var minX = Math.min(c1.x, c2.x),
                maxX = Math.max(c1.x, c2.x),
                minY = Math.min(c1.y, c2.y),
                maxY = Math.max(c1.y, c2.y);

            for(var x = minX; x <= maxX; x++) {
                for(var y = minY; y <= maxY; y++) {
                    callback(x, y);
                }
            }
        }

        function moveSelected(dX, dY) {
            // Вырезаем выделенное
            var selected = $schema.find('.selected'),
                newSelected = $();

            // Проверка координат
            selected.each(function() {
                var coords = $(this).data('coords');

                if (coords.x + dX < 0 || coords.x + dX >= width ||
                    coords.y + dY < 0)
                    throw 'oob';
            });

            // Подготавливаем выделение к переносу
            selected.each(function() {
                var coords = $(this).data('coords'),
                    cell = $(this),
                    newCell = $cell(coords.x + dX, coords.y + dY, true);

                newSelected = newSelected.add(newCell);

                newCell.data('moving', cell.children());

                // Выделенные не трогаем, там уже все схоронено
                if(!newCell.hasClass('selected'))
                    newCell.data('underLayer', newCell.contents().detach());
            });

            // Восстанавливаем подложку
            selected.each(function() {
                var cell = $(this);

                // Только там, куда выделение не перемещается
                if(!cell.data('moving')) {
                    cell.append(cell.data('underLayer'));
                    cell.removeData('underLayer');

                    cell.removeClass('selected');

                    elementor.fixItem(cell);
                }
            });

            // Перемещаем выделение
            newSelected.each(function() {
                var cell = $(this);

                cell.append(cell.data('moving'));
                cell.removeData('moving');
                cell.addClass('selected');

                elementor.fixItem(cell);
            });
        }

        function moveCursor(dX, dY, shift, ctrl) {
            if(move) {
                try {
                    moveSelected(dX, dY);
                } catch(e) {
                    if(e == 'oob')
                        return;
                }
                shift = ctrl = false;
            }

            var newPos = {
                x: cursorPos.x + dX,
                y: cursorPos.y + dY
            };

            if (newPos.x < 0 || newPos.x >= width ||
                newPos.y < 0 || newPos.y >= height) {
                return;
            }

            // Начало выделения
            if(shift && !rectStart) {
                rectStart = cursorPos;
            }

            // Конец выделения
            if(!shift) {
                rectStart = null;
                $schema.find('.rect').removeClass('rect');
            }

            if(shift) {
                var oldRect = {};

                $schema.find('.rect').each(function() {
                    var c = $(this).data('coords');
                    oldRect[[c.x, c.y]] = c;
                });

                rectEach(rectStart, newPos, function(x, y) {
                    if([x, y] in oldRect) {
                        delete oldRect[[x, y]];
                    } else {
                        $cell(x, y).addClass('rect');
                    }
                });

                // Старое выделение, нужно убрать
                $.each(oldRect, function(_, c) {
                    $cell(c.x, c.y).removeClass('rect');
                });
            }

            // Рисование
            if(ctrl) {
                var c;

                if(dX > 0) {
                    c = 'r';
                } else if(dX < 0) {
                    c = 'l';
                } else if(dY > 0) {
                    c = 'b';
                } else if (dY < 0) {
                    c = 't';
                }

                elementor.addConnection($cursor(), c);
            }

            moveCursorTo(newPos);

            if(ctrl) {
                var c;

                if(dX > 0) {
                    c = 'l';
                } else if(dX < 0) {
                    c = 'r';
                } else if(dY > 0) {
                    c = 't';
                } else if (dY < 0) {
                    c = 'b';
                }

                elementor.addConnection($cursor(), c);
            }

            var cursorOffset = $cursor().offset();

            if(cursorOffset.top - 100 < $(window).scrollTop())
                $(window).scrollTop(cursorOffset.top - 100);

            if(cursorOffset.top + 25 + 100 > $(window).scrollTop() + $(window).height())
                $(window).scrollTop(cursorOffset.top + 25 + 100 - $(window).height());
        }

        function destroy() {
            if(!$schema.find('.rect').removeClass('rect').filter(':has(img)').addClass('selected').length) {
                // Нет прямоугольника
                $cursor().addClass('selected');
            }

            $schema.find('.selected').each(function() {
                var coords = $(this).data('coords');

                elementor.changeItem($(this), null);

                function removeConnection(dX, dY, c) {
                    var cell = $cell(coords.x + dX, coords.y + dY);

                    if(!cell.hasClass('selected'))
                        elementor.removeConnection(cell, c);
                };

                removeConnection(-1, 0, 'r');
                removeConnection(1, 0, 'l');
                removeConnection(0, -1, 'b');
                removeConnection(0, 1, 't');
            }).removeClass('selected');
        }

        function cut() {
            if(!$schema.find('.rect').removeClass('rect').filter(':has(img)').addClass('selected').length) {
                // Нет прямоугольника
                $cursor().addClass('selected');
            }
            move = true;
        }

        function paste() {
            $schema.find('.selected').removeClass('selected');
            move = false;
        }

        function undo() {

        };

        function editText() {
            var value = $cursor().find('span').html(),
                newValue = window.prompt(gettext('Подпись'), value);

            if(newValue !== null) // Не отмена
                if(newValue)
                    (value ? $cursor().find('span') : $('<span />').prependTo($cursor().find('a').andSelf().last())).html(newValue);
                else
                    $cursor().find('span').remove();

            fixItem($cursor());
        }

        function editLink() {
            var value = $cursor().find('a').attr('href') || '',
                newValue = window.prompt(gettext('Ссылка'), value);

            if(newValue !== null) // Не отмена
                if(newValue)
                    (value ? $cursor().find('a') : $cursor().wrapInner('<a class="b-link" />').children()).attr('href', newValue);
                else
                    $cursor().find('a').children().unwrap();
        }

        function setZoneClasses() {
            // Проставление классов
            $schema.children().removeClass('b-scheme__zone_type_1 b-scheme__zone_type_2 b-scheme__zone_position_first').each(function(i) {
                if(i == 0) {
                    $(this).addClass('b-scheme__zone_position_first');
                }

                $(this).addClass('b-scheme__zone_type_' + ((i % 2) + 1));
            });
        }

        function deleteZone() {
            // Удаление зоны
            var $row = $cursor().closest('.b-scheme__row'),
                $zone = $row.parent();

            if($zone.next().length) {
                $zone.next().prepend($zone.children('.b-scheme__row'));

                $zone.remove();
                setZoneClasses();
            }
        }

        function editZone() {
            var $row = $cursor().closest('.b-scheme__row'),
                $zone = $row.parent(),
                value = $zone.metadata().num,
                newZone = window.prompt(gettext('Зона (X - покилометровый тариф, Z - без названия)'), value == 'Z' ? '' : value),
                newZoneRows = $row.prevAll('.b-scheme__row').andSelf(),
                $newZone;

            if(newZone === null)
                return;

            if(!newZone)
                newZone = 'Z';
            else if('xXхХ'.indexOf(newZone) != -1)
                newZone = 'X';

            if($row[0] == $zone.children('.b-scheme__row:last')[0]) {
                // Изменение зоны

                $newZone = $zone;
            } else {
                // Добавление новой зоны
                $newZone = $('<div class="b-scheme-zone" />').insertBefore($zone).append(newZoneRows);
                setZoneClasses();
            }

            if(newZone != 'Z') {
                var num = '', name;

                if(newZone == 'X') {
                    name = gettext('покилометровый тариф');
                } else {
                    num = newZone + ' ';
                    name = gettext('зона');
                }

                $newZone.find('.b-scheme__num').html(num + '<span>' + name + '</span></b>').length ||
                    $newZone.prepend('<div class="b-scheme__num">' + num + '<span>' + name + '</span></b>');

                $newZone.data('metadata', {'num': newZone});
            } else {
                $newZone.find('.b-scheme__num').remove();
                $newZone.data('metadata', {'num': newZone});
            }
        }

        function insertRow(above) {
            var $row = $cursor().closest('.b-scheme__row'),
                $newRow = $('<div class="b-scheme__row g-line" />');

            if(above) {
                $newRow.insertBefore($row);
                cursorPos = {
                    x: cursorPos.x,
                    y: cursorPos.y + 1
                };
            } else {
                $newRow.insertAfter($row);
            }

            for(var i = 0; i < 31; i++) {
                $('<i class="item" />').appendTo($newRow);
            }

            mapCells();
        }

        function changeType() {
            elementor.changeType($cursor());
        }

        function insertCell() {
            var $prev,
                $columnItems = $cursor().closest('.b-scheme__row').nextAll().andSelf().find('.b-scheme__item:eq(' + cursorPos.x + ')');

            $columnItems.each(function() {
                var $content = $(this).children().detach();

                if($prev) {
                    $(this).append($prev);
                }

                $prev = $content;
            });

            elementor.fixItems($columnItems);
        }

        function removeCell() {
            var i = 0,
                $prev,
                $columnItems = $cursor().closest('.b-scheme__row').nextAll().andSelf().find('.b-scheme__item:eq(' + cursorPos.x + ')');

            for(; i < $columnItems.length - 1; i++) {
                $columnItems.eq(i).append($columnItems.eq(i + 1).children().detach());
            }
            elementor.fixItems($columnItems);
        };

        function addStation() {
            // console.log('ds');

            var href = '../../?_to_field=id&_popup=1&suburban_zone__id__exact=' + window.suburban_zone_id;

            window.dismissRelatedLookupPopup = function(win, directionId) {
                $.getJSON("../../" + directionId + "/stations/", function(data) {
                    // console.log(data);
                });

                move = true;

                win.close();
            };


            var win = window.open(href, name, 'height=500,width=800,resizable=yes,scrollbars=yes');

            win.focus();
        };

        $(document).keypress(function (e) {
            var propagate = false;

            if(e.keyCode) {
                // Спецклавиши
                switch(e.keyCode) {
                case 13:
                    paste();
                    break;
                case 37:
                    moveCursor(-1, 0, e.shiftKey, e.ctrlKey);
                    break;
                case 38:
                    moveCursor(0, -1, e.shiftKey, e.ctrlKey);
                    break;
                case 39:
                    moveCursor(1, 0, e.shiftKey, e.ctrlKey);
                    break;
                case 40:
                    moveCursor(0, 1, e.shiftKey, e.ctrlKey);
                    break;
                case 46:
                    destroy();
                    break;
                default:
                    propagate = true;
                }
            } else {
                // console.log(e.which);

                // Буквы
                switch(e.which) {
                case 120:
                    cut();
                    break;
                case 90:
                    editZone();
                    break;
                case 122:
                    deleteZone();
                    break;
                case 116:
                    editText();
                    break;
                case 104:
                    editLink();
                    break;
                case 79:
                    insertRow(false);
                    break;
                case 111:
                    insertRow(true);
                    insertRow(e.shiftKey);
                    break;
                case 99:
                    changeType();
                    break;
                case 105:
                    insertCell();
                    break;
                case 73:
                    removeCell();
                    break;
                case 115: // S
                    addStation();
                    break;
                default:
                    propagate = true;
                }
            }

            return propagate;
        });

        function encodeSchema() {
            var data = $schema.children().map(function () {
                var $zone = $(this),
                    rows = [];

                $zone.children('.b-scheme__row').each(function () {
                    var row = $(this).children().map(function() {
                        var $item = $(this),
                            obj = $item.find('img').data('obj');

                        return {
                            item: obj && obj.img,
                            href: $item.find('a').attr('href'),
                            label: $item.find('span').html()
                        };
                    });

                    rows.push($.makeArray(row));
                });

                return {
                    num: $zone.metadata().num,
                    rows: rows
                };
            });

            $("input[name=schema]").val($.toJSON($.makeArray(data)));
        }

        $('form').submit(function () {
            encodeSchema();
        });
    });

    if (typeof ymaps != 'undefined') {
        ymaps.ready(function() {

            $('.ymaps-point').each(function() {

                var locationEl = $(this),
                    zoomButton = $('<input type="button" value="' + gettext("Сохранить масштаб") + '" />'),
                    mapEl = $('<div style="height: 400px; width: 100%"></div>'),
                    idEl = $('input[name=stationterminal_set-0-station]'),
                    lngEl = $('input[name=longitude]'),
                    latEl = $('input[name=latitude]'),
                    zoomEl = $('input[name=map_zoom]'),
                    threadPaths = null;

                zoomButton.appendTo(locationEl).wrap('<div class="form-row" />').parent().prepend(mapEl);

                var map = new ymaps.Map(mapEl[0], {
                    center: [55.74954, 37.621587],
                    zoom: 10,
                    behaviors: [ 'default' ]
                });

                zoomButton.click(function () {
                    zoomEl.val(map.getZoom());
                });

                map.controls
                    .add('typeSelector')
                    .add('zoomControl');

                // map.enableScrollZoom();

                var placemark;

                function setPlaceMark(point, setCoords) {

                    if(setCoords) {

                        latEl.val(point[0]);
                        lngEl.val(point[1]);

                    }

                    if(!placemark) {

                        placemark = new ymaps.Placemark(point, {}, {draggable: true});
                        map.geoObjects.add(placemark);

                        placemark.events.add('geometrychange', function (e) {

                            var pt = placemark.geometry.getCoordinates();

                            latEl.val(pt[0]);
                            lngEl.val(pt[1]);
                        });

                        placemark.events.add('geometrychange', function (e) {
                            if (threadPaths === null) {
                                threadPaths = true;
                                $.getJSON('/admin/lime/station/' + idEl.val() + '/segments/', {}, function (data) {
                                    threadPaths = data.segments;

                                    if (threadPaths.length > 0) {
                                        latEl.css('color', 'red');
                                        lngEl.css('color', 'red');

                                        var lhtml = "<a href='/admin/lime/?mode=stations&station=" + idEl.val() + "' >" +
                                            gettext('Исправить сементы') + "</a>";
                                        lngEl.parent().append(lhtml);
                                        latEl.parent().append(lhtml)

                                        alert("Через станцию проходит " + threadPaths.length + " сегментов маршрутов с геометрией.");
                                    }
                                });
                            }

                        });

                    } else {

                        placemark.geometry.setCoordinates(point);

                    }

                }

                if(lngEl.val() && latEl.val()) {

                    var point = [ latEl.val(), lngEl.val() ];

                    map.setCenter(point, zoomEl.val() || 10);
                    setPlaceMark(point);

                } else {

                    map.setCenter([60, 93], 3);
                    var region, settlement;

                    try {
                        region = $('.region strong').html();
                    } catch (e) {};

                    try {
                        settlement = $('.settlement strong').html();
                    } catch (e) {};

                    var geocoder = ymaps.geocode(settlement || region, {results: 1});

                    geocoder.then(
                        function (res) {
                            if( res.geoObjects.getLength() ) {
                                map.setCenter(res.geoObjects.get(0).geometry.getCoordinates(), settlement ? 10 : 8);
                            }
                    });

                }

                map.events.add('click', function (e) {

                    var pt = e.get('coords');

                    setPlaceMark(pt, true);

                });

            });

            $('.rthread-stations').each(function() {

                var map,
                    bounds = [],
                    stations = $('input[name=station]').map(function() {return this.value;});

                map = new ymaps.Map(this, {
                    center: [55.74954, 37.621587],
                    zoom: 10,
                    behaviors: [ 'default' ]
                });

                map.controls
                    .add('typeSelector')
                    .add('zoomControl')
                    .add('mapTools');

                $.each(stations, function(i, station) {
                    var inputs = $('input[name=station_' + station + '_lat], input[name=station_' + station + '_lng]'),
                        approx = $('input[name=station_' + station + '_approx]'),
                        point = [ inputs.eq(0).val(), inputs.eq(1).val() ],
                        name = $('input[name=station_' + station + '_title]').val(),
                        placemark;

                    placemark = new ymaps.Placemark(point, {
                        iconContent: name,
                        balloonContent:
                            station + "<br>" +
                            name + "<br>" +
                            "<a href=\"/admin/www/station/" + station + "/\" target=\"_blank\">" + gettext('Редактировать в геоадмине') + "</a>"
                    }, {
                        preset: 'islands#blackStretchyIcon',
                        draggable: true,
                        hasBalloon: true
                    });

                    marks[station] = placemark;

                    placemark.events.add('geometrychange', function (e) {

                        pt = placemark.geometry.getCoordinates();

                        inputs.eq(0).val(pt[0]);
                        inputs.eq(1).val(pt[1]);

                        approx.val('');

                        placemark.options.set('preset', 'islands#redStretchyIcon');
                    });

                    if(approx.val()) {
                        placemark.options.set('preset', 'islands#brownStretchyIcon');
                    }

                    map.geoObjects.add(placemark);

                    // console.log(point);

                    bounds.push(point);
                });

                map.setBounds(map.geoObjects.getBounds());

            });

        });
    }

});
