var templates = {
    cached: {},

    load: function() {
        /**
         * @this templates
         * @param {...string} template - шаблоны для загрузки
         * @param {loadCallback} callback - вызывается при загрузке всех шаблонов,
         *   loadCallback([data, deferred], [data, deferred]...)
         */
        var self = this;
        var args = _.toArray(arguments);
        var callback = args.pop();
        var templateDfs = [];

        _.each(args, function(templateUrl) {
            var deffered = self.getTemplateDeffered(templateUrl);
            templateDfs.push(deffered);
        });

        $.when.apply($, templateDfs).then(function() {
            callback.apply(null, arguments);
        });
    },

    getTemplateDeffered: function(templateUrl) {
        if (!_.has(this.cached, templateUrl)) {
            this.cached[templateUrl] = $.get(templateUrl, null, null, "text");
        }

        return this.cached[templateUrl];
    }
};

function BlueStation(s) {
    var self,
        handleWwwStationsOnRedraw,
        styles = {
            normal : { preset: 'islands#greenIcon' },
            red : { preset: 'islands#redIcon' },
            yellow : { preset: 'islands#yellowIcon' },
            orange : { preset: 'islands#darkorangeIcon' },
            brown : { preset: 'islands#brownIcon' }
        };

    self = {
        www_station: {},

        whatStyle : function() {
            if (self.www_station.id) {
                if (self.www_station.geo)
                    return 'normal'; // Привязанная к геокодированной
                else {
                    return 'brown'; // Привязанная к негеокодированной станции
                }
            } else {
                if (self.placed)
                    return 'yellow'; // Непривязанная, но установленная мышью на карте, готовая к созданию
                else
                    return 'red'; // Непришей козе хвост
            }
        },

        setIconStyleProperties : function(styleName) {
            var style = styles[styleName];
            if (!self.pm || !style) { return; }

            $.each(style, function(k, v) {
                self.pm.options.set(k, v);
            });
        },

        setStyle : function(styleName) {
            if (styleName == 'normal') {
                setTimeout(function() {
                    self.setIconStyleProperties(styleName);
                }, 220);
            } else {
                self.setIconStyleProperties(styleName);
            }
        },

        setWhatStyle : function() {
            self.setStyle(self.whatStyle());
        },

        getPm : function() {
            return self.pm;
        },

        pmCreate : function() {
            var options,
                wwwStation = wwwStations.getById(self.www_station.id),
                lon = wwwStation && wwwStation.lon || null,
                lat = wwwStation && wwwStation.lat || null,
                tr_additional_info = '';
                //country = blueOptions.country;

            if (!lon || !lat) {
                lon = self.lon;
                lat = self.lat;
            }

            if (!self.pm) {
                options = {
                    draggable: true
                };

                function shortText(maxsize, text) {
                    var trimmed = $.trim(text);
                    return trimmed.length > maxsize ? trimmed.substr(0, maxsize-3) + '...' : trimmed;
                }

                if (self.additional_info) {
                    tr_additional_info = '<tr><td>Доп. инфо</td><td>' +
                        '<div href=# class="p-show-additional-info" data="' + self.additional_info + '">' +
                            shortText(40, self.additional_info) +
                        '</div>' +
                        '</td></tr>';
                }

                var templateParams = {
                    "self": self,
                    "tr_additional_info": tr_additional_info,
                    "wwwStations": wwwStations,
                    "district": district,
                    "region": region,
                    "country": country
                };

                if (self.www_station.id) {

                    self.pm = new ymaps.Placemark(
                        [lon, lat], {
                            iconContent: self.number,
                            hintContent: self.code + '<br />' + self.title
                        },
                        options
                    );

                    templates.load(
                        '/static/rasp/blue/jstemplates/mapped_station_balloon.html',
                        '/static/rasp/blue/jstemplates/common_station_params.html',
                        function(template, stationParams) {
                            if (!self.pm) {
                                return;
                            }

                            var params = _.extend({'stationParamsTemplate': _.template(stationParams[0])},
                                templateParams);

                            self.pm.properties.set("balloonContent", _.template(template[0], params));
                        }
                    );

                } else {
                    self.pm = new ymaps.Placemark(
                        [lon, lat], {
                            iconContent: self.number,
                            hintContent: self.code + "<br />" + self.title
                        },
                        options
                    );

                    templates.load(
                        '/static/rasp/blue/jstemplates/not_mapped_station_balloon.html',
                        '/static/rasp/blue/jstemplates/common_station_params.html',
                        function(template, stationParams) {
                            if (!self.pm) {
                                return;
                            }

                            var params = _.extend({'stationParamsTemplate': _.template(stationParams[0])},
                                templateParams);
                            self.pm.properties.set("balloonContent", _.template(template[0], params));
                        }
                    );

                }

                self.setIconStyleProperties(self.whatStyle());

                self.pm.blue_station_id = self.id;

                self.pm.events.add('mouseenter', function() {
                    self.get$tr().addClass('hover');
                });

                self.pm.events.add('mouseleave', function() {
                    self.get$tr().removeClass('hover');
                });

                self.pm.events.add('drag', function () {
                    $blueCallbacks.trigger('stationDrag', {station: self});
                });

                self.pm.events.add('dragend', function () {
                    $blueCallbacks.trigger('stationDragEnd', {station: self});
                });

                map.geoObjects.add(self.pm);
            }
        },

        pmUpdate: function() {
            if (self.pm) {
                self.pmDelete();
            }
            self.pmCreate();
        },

        pmDelete: function() {
            if (self.pm) {
                map.geoObjects.remove(self.pm);
                self.pm = null;
            }
        },

        update : function(s) {
            if (typeof(s) != 'undefined') {
                $.each(['id', 'code', 'title', 'number', 'lon', 'lat',
                        'additional_info',
                        'station_mapping_id',
                        'allow_fuzzy',
                        'fuzzy_flag_id',
                        'is_fuzzy',
                        'is_searchable_to',
                        'is_searchable_from',
                        'in_station_schedule'],
                    function(j, k) {
                        if (typeof(s[k]) != 'undefined') {
                            self[k] = s[k];
                        }
                    }
                );

                if (!self.www_station.id || s.station) {
                    self.www_station = s.station || {};
                }

                if(_.isFinite(self.lon) && _.isFinite(self.lat)) {
                    if (self.www_station.id) {
                        self.www_station.geo = true;
                    } else {
                        self.placed = true;
                    }
                }

                self.real_title = s['real_title'] || self.title

            }

            if (!self.number) {
                self.number = '';
            }

            self.pmUpdate();
            self.check$trClasses();

        },

        trHtml : function() {
            return '<td><b>' + self.number + '</b></td>' +
                   '<td class="i-title">' + self.title + '</td>';
        },

        check$trClasses : function() {
            if (self.www_station.id) {
                self.get$tr().addClass('mapped');
                if (self.www_station.geo) {
                    self.get$tr().removeClass('geoless');
                } else {
                    self.get$tr().addClass('geoless');
                }
            } else {
                self.get$tr().removeClass('mapped');
                self.get$tr().removeClass('geoless');
            }
        },

        get$tr : function(){
            if (!self.$tr) {

                self.$tr = $('<tr>' + self.trHtml() + '</tr>');

                if (self.www_station.id) {
                    self.$tr.addClass('mapped');
                }

                self.$tr.hover(
                    function() {
                        self.setStyle('yellow');
                        self.$tr.addClass('hover');
                    },
                    function() {
                        self.$tr.removeClass('hover');
                        self.setWhatStyle();
                    });

                self.$tr.click(function() {
                    var wwwStation = wwwStations.getById(self.www_station.id),
                        lon = wwwStation && wwwStation.lon,
                        lat = wwwStation && wwwStation.lat;

                    if (!lon || !lat) {
                        lon = self.lon;
                        lat = self.lat;
                    }

                    if (lon && lat) {
                        map.setCenter([lon, lat], 11, { duration: 330 });
                    }
                });
            }

            return self.$tr;
        },

        unmap : function() {

            $.post('/admin/blue/station/' + s.id + '/?action=unmap', {'id':s.id}, function(response) {
                if (response.status == 'ok') {
                    self.www_station = {};
                    self.update();
                    self.get$tr().removeClass('geoless');
                    self.get$tr().removeClass('hover');
                    self.get$tr().removeClass('mapped');
                    metarouteCheckUnmappedCount();
                }
            });

        },

        destruct : function() {
            self.pmDelete();

            // Отвязать обработчик обновления метки
            wwwStations.unbind('redraw', handleWwwStationsOnRedraw);

            if (self.$tr) {
                self.$tr.remove();
                self.$tr = null;
            }
        },

        updateFromWwwStation : function(s) {
            var data = {};
            $.each(['lon', 'lat'], function(j, k) {
                data[k] = s[k];
            });
            data.station = s;
            self.update(data);
        },

        mapToWwwStation : function(wwwStation) {
            var data = {'www_station_id': wwwStation.id};
            function confirmTTypeBinding() {
                return confirm(
                    gettext('ВНИМАНИЕ! Тип транспорта станции') + ': "' + options.t_types[wwwStation.t_type_id].title +
                    '". ' + gettext('Действительно привязать?')
                );
            }

            function confirmBinding() {
                return confirm(
                    gettext('Привязать станцию поставщика') + ' '+ self.code + ' "' + self.title + '" ' +
                    gettext('к станции в базе') + ' ' + wwwStation.id + ' "' + wwwStation.title + '"?'
                );
            }

            if (
                (wwwStation.t_type_id == 3 || confirmTTypeBinding()) && confirmBinding()
            ) {
                $.post('/admin/blue/station/' + self.id + '/?action=map', data, function(response) {
                    if (response.status == 'ok') {
                        self.updateFromWwwStation(wwwStation);
                        self.get$tr().removeClass('hover');
                        self.get$tr().addClass('mapped');
                        metarouteCheckUnmappedCount();
                    } else {
                        self.setWhatStyle();
                        alert(gettext('Ошибка, новое соответствие не создано'));
                    }
                });
            } else {
                self.placed = true;
                self.setWhatStyle();
            }
        },

        newMapping : function(station) {
            var data = _.extend(
                {
                    'lon': self.lon,
                    'lat': self.lat
                },
                station, {'title': station.title || self.title}
            );

            $.post('/admin/blue/station/' + self.id + '/?action=new_map', data, function(response) {
                if (response.status == 'ok') {
                    map.balloon.close();
                    self.geo = true;
                    self.update(response);
                    if (station.title) {
                        wwwStations.redraw();
                        metarouteCheckUnmappedCount();
                    }
                    self.get$tr().removeClass('hover');
                    self.get$tr().addClass('mapped');
                }
            });
        }

    };

    // Привязать обработчик обновления метки
    handleWwwStationsOnRedraw = function () {
        self.pmUpdate();
    };
    wwwStations.bind('redraw', handleWwwStationsOnRedraw);

    wwwStations.bind('moved', function(e, data) {
        if (data.station.id == self.www_station.id) {
            self.update({lon: data.station.lon, lat: data.station.lat});
        }
    });

    wwwStations.bind('prejoined', function(e, data) {
        if (data.src.id == self.www_station.id) {
            self.updateFromWwwStation(data.dst);
        }
    });

    wwwStations.bind('majorityChanged', function(e, data) {
        if (data.www_station.id == self.www_station.id) {
            self.www_station.majority_id = data.www_station.majority_id;
            self.pmDelete();
            self.pmUpdate();
        }
    });

    self.update(s);

    return self;
}
