include('../rainbow/ajax.js');
include('../rainbow/improvedRelatedObjectLookups.js');
include('../rainbow/ymapsUtils.js');
include('../rainbow/WwwStations.js');
include('../rainbow/StationLayersControl.js');
include('../rainbow/StationZoomControl.js');
include('../rainbow/behaviorInfo.js');
include('fuzzy_utils.js');

function yaBlue(mapSelector, mediaUrl, options) {
    if (!ymaps) {
        throw 'ymaps is required';
    }

    if(options === undefined)
        options = {};

    include('../rainbow/statusBar.js');
    include('../rainbow/Goroda.js');

    var initial = ymapsUtils.getHashParams(),
        metaroute,
        map,
        statusBar = StatusBar(),
        layersControl = new StationLayersControl(options, mediaUrl),
        busZoomControl = new StationZoomControl(gettext('Автобусы'), 'map_bus_zoom', options),
        pseudoZoomControl = new StationZoomControl(gettext('Псевдо-гортранс'), 'map_pseudo-gortrans_zoom', options),
        wwwStations,
        behaviorHand, behaviorGoroda,
        goroda,
        city = options.city || {},
        country = options.country || {},
        region = options.region || {},
        district = options.district || {},
        metathreads = options.metathreads || {};

    if(initial.route_id) {
        options.route_id = initial.route_id;
    }

    if(initial.center) {
        options.center = initial.center.split(',');
    } else if(city.lon &&city.lat) {
        options.center = [city.lon, city.lat];
    } else {
        options.center = [37.64, 55.76];
    }

    if(initial.zoom) {
        options.zoom = initial.zoom;
    }

    map = new ymaps.Map(mapSelector, {
        center: options.center,
        zoom: options.zoom || 10,
        type: "yandex#map",
//        type: "yandex#hybrid",
        behaviors: ["default", "scrollZoom"]
    });

    map.behaviors.disable('dblClickZoom');

    map.controls.add("zoomControl").add("typeSelector").add("scaleLine");

//    map.options.set('dragCursor', 'arrow');

    // --------- переключатели режимов карты ---------
    // режим "лапка"
    behaviorHand = new ymaps.control.mapTools.button.Drag();

    // режим "города"
    behaviorGoroda = new ymaps.control.Button({data: { content: gettext('Города') }});
    behaviorGoroda.events.add('select', function() {
        // Включить режим "Города"
        goroda.open();
    });
    behaviorGoroda.events.add('deselect', function() {
        // Выключить режим "Города"
        goroda.close();
    });

    // Устанавливаем кнопки режимов на карту
    map.controls.add(new ymaps.control.MapTools({
        items: [
            behaviorHand,
            behaviorInfo(map),
            behaviorGoroda,
            layersControl.control,
            busZoomControl.control,
            pseudoZoomControl.control
        ]
    }));
    // --------- /переключатели режимов карты ---------

    map.events.add('boundschange', function() {
        var center = map.getCenter();
        ymapsUtils.setHashParams({
            center: '' + center[0] + ',' + center[1],
            zoom: map.getZoom()
        });
        wwwStations.redraw();
    });

    wwwStations = WwwStations(map, mediaUrl, function() {
        return 3
    }, options, layersControl, [layersControl.events, busZoomControl.events, pseudoZoomControl.events]);

    include('Metaroute.js');

    metaroute = Metaroute();

    goroda = Goroda(map, wwwStations);

    // Настроить первоначальное состояние окна
    if(options.route_id) {
        metaroute.select(options.route_id, { doNotFocuse : (initial.center || initial.zoom) && true || false });
    }

    $('.b-control-package SELECT[name=package]').bind('change', function() {
        window.location.href = '/admin/blue/' + $(this).val() + '/';
    });

    $(document).delegate('.b_balloon_cancel', 'click', function(e) {
        map.balloon.close();
    });

    $(document).delegate('.p-show-additional-info', 'click', function(e) {
        var $elem = $(e.currentTarget);
        statusBar.say('<pre>' + $('<div/>').text($elem.attr('data')).html() + '</pre>', {wait:15000});
    });

    $('#map').delegate('.js-save-station-params', 'click', function() {
        var $form = $(this).closest('form'),
            stationId = $form.attr('data-station_id'),
            tsiStationId = $form.attr('data-tsi_station_id'),
            tsiStationFlags = {
                'is_fuzzy': $('.fuzzy-flag[name=is_fuzzy]', $form).val(),
                'is_searchable_from': $form.find('.fuzzy-flag[name=is_searchable_from]').val(),
                'is_searchable_to': $form.find('.fuzzy-flag[name=is_searchable_to]').val(),
                'in_station_schedule': $form.find('.fuzzy-flag[name=in_station_schedule]').val()
            },
            station = {
                'id': stationId,
                'majority_id': $form.find('select[name=majority_id]').val(),
                'station_type_id': $form.find('select[name=station_type_id]').val(),
                't_type_id': $form.find('select[name=t_type_id]').val()
            };

        var def1 = wwwStations.updateStation(station);
        var def2 = metaroute.updateTsiStationFlags(tsiStationId, tsiStationFlags);

        $.when(def1, def2).then(function(stationResp) {
            var tsiStation = metaroute.getTsiStationById(tsiStationId);
            tsiStation.update(_.extend({'id': tsiStationId, 'station': stationResp[0].station}, tsiStationFlags));
        });


        map.balloon.close();
    });

    $('#body_wrapper').resize(function() {
        map.container.fitToViewport();
    });

    function metarouteCheckUnmappedCount() {
        metaroute.checkUnmappedCount();
    };

    wwwStations.redraw();

}

function mapPageFixBodyHeight() {
    $('#body_wrapper').css('top', ($('#head').outerHeight(true)) + 'px')
        .resize();
}
