function fillCalendar($widget) {
    var $input = $widget.find('input[type="hidden"]');

    var yearDays = $input.val();
    for (var m = 1; m <= 12; m++) {
        for (var d = 1; d <= 31; d++) {
            var pos = (m - 1) * 31 + d - 1;
            if (yearDays.charAt(pos) === '1') {
                $widget.find('.js-day-' + m + '-' + d).addClass('day_present');
            } else {
                $widget.find('.js-day-' + m + '-' + d).addClass('day_absent');
            }
        }
    }
}


function changeMaskDay($widget, month, day, value) {
    var $input = $widget.find('input[type="hidden"]');
    var yearDays = $input.val();
    var pos = (month - 1) * 31 + day - 1;

    if (value == 'toggle') {
        value = yearDays.charAt(pos) == '1' ? '0' : '1';
    }

    yearDays = yearDays.substr(0, pos) + value + yearDays.substr(pos + 1);
    $input.val(yearDays);

    if (value === '1') {
        $widget.find('.js-day-' + month + '-' + day).removeClass('day_absent');
        $widget.find('.js-day-' + month + '-' + day).addClass('day_present');
    } else {
        $widget.find('.js-day-' + month + '-' + day).removeClass('day_present');
        $widget.find('.js-day-' + month + '-' + day).addClass('day_absent');
    }
}


function changeMonth($widget, $month, type) {
    var monthNumber = $month.data('month');
    $month.find('td.js-day-container:has(a)').each(function () {
        var $td = $(this);
        var day = $td.data('day');
        var value;

        switch (type) {
            case 'all':
                value = '1';
                break;
            case 'even':
                value = day % 2 == 1 ? '0' : '1';
                break;
            case 'odd':
                value = day % 2 == 1 ? '1' : '0';
                break;
            case 'workday':
            case 'holiday':
                value = $td.hasClass(type) ? '1' : '0';
                break;
            case 'none':
                value = '0';
                break;
        }

        changeMaskDay($widget, monthNumber, day, value);
    });

    return false;
}


function changeYear($widget, type) {
    $widget.find('table.month_table').each(function() {
        changeMonth($widget, $(this), type);
    });
}

function setUpCalendars() {
    $('.js-calendar-widget').each(function() {
        setUpCalendar($(this));
    });
    $('body').on('click', '.add-row a', function() {
        setTimeout(setUpCalendars, 300);
    });
}

function setUpCalendar($widget) {
    if ($widget.data('configured')) {
        return;
    }
    $widget.find('.js-year-action').click(function() {
        changeYear($widget, $(this).data('type'));
    });

    $widget.find('.js-month-action').click(function() {
        var $month = $(this).closest('.month_table');
        changeMonth($widget, $month, $(this).data('type'));
    });

    $widget.on('click', '.js-day-container a', function(event) {
        var $a = $(event.target);
        var $td = $a.closest('.js-day-container');
        var $month = $a.closest('.month_table');

        changeMaskDay($widget, $month.data('month'), $td.data('day'), 'toggle');
    });

    fillCalendar($widget);

    $widget.data('configured', true);
}
