var _ = require('underscore'),
    Marionette = require('Marionette'),
    Maps = require('maps'),
    Sidebar = require('sidebar'),
    Notificator = require('notificator');

require('csrftoken');
require('ajax');

var GeoApplication = Marionette.Application.extend({
    modules: {},

    addModules: function(modules) {
        _.each(modules, function(module) {
            this.addInitializer(function(options) {
                options.app.modules[module.name] = new module.controller(options);
            });
        }, this);
    },

    // Переопределение метода start, для подтягивания конфига и ожидания карты
    start: function(options) {
        var self = this;

        _.extend(options, window.serverConfig);
        options.app = self;
        self.config = options;
        ymaps.ready(function() {
            Marionette.Application.prototype.start.call(self, options);
        });
    }
});

var init = function() {
    var app = new GeoApplication();

    app.addRegions({
        mapsRegion: '#maps',
        sidebarRegion: '.island__content'
    });

    // Инициализация карты перед всеми модулями
    app.addInitializer(function(options) {
        app.maps = new Maps(options);
    });

    // Контролы карты и сайдбар - после всех модулей
    app.on('initialize:after', function(options) {
        app.maps.addControls();
        app.sidebar = new Sidebar(options);
        app.notificationBlock = new Notificator({
            dispatcher: app
        });

        $('.island').bem('island');
        BEM.DOM.init();
    });

    return app;
};

module.exports = (function() {
    // Синглтон экспортируем в глобальную область видимости
    if (window.app) {
        return window.app;
    }

    window.app = init();
    return window.app;
})();
