var BackboneYmaps = require('Backbone.Ymaps');

var BalloonPlacemark = BackboneYmaps.Placemark.extend({
    events: {
        'balloonopen': 'onBalloonOpen',
        'balloonclose': 'onBalloonClose',
        'mouseenter': 'onMouseEnter',
        'mouseleave': 'onMouseLeave'
    },

    styles: {
        green: 'islands#greenIcon',
        red: 'islands#redIcon',
        yellow: 'islands#yellowIcon',
        orange: 'islands#darkorangeIcon',
        brown: 'islands#brownIcon'
    },

    balloonContent: gettext('Загрузка...'),

    onMouseEnter: function() {
        this.model.trigger('hover');
    },

    onMouseLeave: function() {
        this.model.trigger('unhover');
    }

});

module.exports = BalloonPlacemark;
